/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt;

import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class KeyStoreUtils {
    public static final String FAILED_TO_GET_CERTIFICATE_PLEASE_CHECK = "Failed to get certificate, please check";
    private static final String CERT_TYPE = "X.509";

    private KeyStoreUtils() {
    }

    public static PrivateKey getPrivateKeyFromJks(String path, String keyStorePwd, String keyPwd, String alias) {
        PrivateKey privateKey;
        FileInputStream jksInputStream = new FileInputStream(new File(path));
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(jksInputStream, keyStorePwd.toCharArray());
            privateKey = (PrivateKey)keyStore.getKey(alias, keyPwd.toCharArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jksInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new UtilRuntimeException("Failed to get private key, please check", e);
            }
        }
        jksInputStream.close();
        return privateKey;
    }

    public static X509Certificate getX509CertificateFromJks(String path, String keyStorePwd, String alias) {
        X509Certificate x509Certificate;
        FileInputStream jksInputStream = new FileInputStream(new File(path));
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(jksInputStream, keyStorePwd.toCharArray());
            Certificate certificate = keyStore.getCertificate(alias);
            x509Certificate = (X509Certificate)certificate;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jksInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new UtilRuntimeException(FAILED_TO_GET_CERTIFICATE_PLEASE_CHECK, e);
            }
        }
        jksInputStream.close();
        return x509Certificate;
    }

    public static PublicKey getPublicKeyFromCert(String path) throws CertificateException, IOException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE, (Provider)new BouncyCastleProvider());
        try (FileInputStream certInputStream = new FileInputStream(path);){
            Certificate certificate = certificateFactory.generateCertificate(certInputStream);
            PublicKey publicKey = certificate.getPublicKey();
            return publicKey;
        }
    }

    public static KeyStore loadKeyStoreFromJksPath(String jksPath, String alias, String storeType, String passWord) throws GeneralSecurityException, IOException {
        char[] pw = passWord.toCharArray();
        storeType = null == storeType ? KeyStore.getDefaultType() : storeType;
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try (FileInputStream is = new FileInputStream(jksPath);){
            keyStore.load(is, pw);
        }
        return keyStore;
    }

    public static PrivateKey getPrivateKeyFromStore(String jksPath, String alias, String storeType, String passWord) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStoreUtils.loadKeyStoreFromJksPath(jksPath, alias, storeType, passWord);
        return (PrivateKey)keyStore.getKey(alias, passWord.toCharArray());
    }

    public static PublicKey getPublicKeyFromStore(String jksPath, String alias, String storeType, String passWord) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStoreUtils.loadKeyStoreFromJksPath(jksPath, alias, storeType, passWord);
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(alias);
        return x509Certificate.getPublicKey();
    }
}

