/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.io;

import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import cn.com.yusys.yusp.commons.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CompressUtils {
    public static final String THE_DECOMPRESSED_PACKAGE_NOT_EXIST_EX = "The decompressed %s package does not exist[%s]";
    public static final String FILE_SEP = "/";
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";

    private CompressUtils() {
    }

    public static byte[] compressData(byte[] bytes) throws IOException {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(bytes);
        compressor.finish();
        byte[] buf = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);){
            while (!compressor.finished()) {
                int count = compressor.deflate(buf);
                bos.write(buf, 0, count);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static byte[] deCompressData(byte[] bytes) throws DataFormatException, IOException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(bytes);
        byte[] buf = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);){
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static boolean isJarFile(File file) throws IOException {
        boolean manifest;
        if (!CompressUtils.isZipFile(file)) {
            return false;
        }
        try (ZipFile zip = new ZipFile(file);){
            manifest = zip.getEntry(MANIFEST_MF) != null;
        }
        return manifest;
    }

    public static boolean isZipFile(File file) throws IOException {
        int head;
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
            head = in.readInt();
        }
        return head == 1347093252;
    }

    public static void compressJar(String pathName, String jarName, boolean isRoot) throws IOException {
        try (FileOutputStream fos = FileUtils.openOutputStream(new File(jarName));
             JarOutputStream out = new JarOutputStream(fos);){
            CompressUtils.compressOfManifest(out);
            File file = new File(pathName);
            String root = isRoot ? file.getName() + FILE_SEP : "";
            CompressUtils.jarDir(out, file, root);
        }
    }

    private static void jarDir(JarOutputStream out, File file, String root) throws IOException {
        JarEntry jarEntry = new JarEntry(root);
        out.putNextEntry(jarEntry);
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String tmpRoot = root;
            if (files[i].isDirectory()) {
                tmpRoot = tmpRoot + files[i].getName() + FILE_SEP;
                CompressUtils.jarDir(out, files[i], tmpRoot);
                continue;
            }
            CompressUtils.jarFile(out, files[i], tmpRoot);
        }
    }

    private static void jarFile(JarOutputStream out, File file, String root) throws IOException {
        JarEntry jarEntry = new JarEntry(root + FILE_SEP + file.getName());
        out.putNextEntry(jarEntry);
        try (FileInputStream is = new FileInputStream(file);){
            FileUtils.copyStream(is, out);
        }
    }

    private static void compressOfManifest(JarOutputStream out) throws IOException {
        byte[] data = ("Manifest-Version: 1.0\nPlatform: BSP\nBuildTime: " + new SimpleDateFormat("yyyy-MM-dd").format(new Date())).getBytes();
        JarEntry jarEntry = new JarEntry(MANIFEST_MF);
        out.putNextEntry(jarEntry);
        out.write(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deCompressJar(String jarName, String filePath) throws IOException {
        File file = new File(jarName);
        if (!file.exists()) {
            throw new UtilRuntimeException(String.format(THE_DECOMPRESSED_PACKAGE_NOT_EXIST_EX, "jar", file.getAbsolutePath()));
        }
        FileUtils.openFileDir(filePath);
        try (JarInputStream jis = new JarInputStream(new FileInputStream(file));){
            while (true) {
                FileOutputStream fos;
                block25: {
                    JarEntry jarEntry;
                    if ((jarEntry = jis.getNextJarEntry()) == null) {
                        return;
                    }
                    if (jarEntry.isDirectory() || "".equals(jarEntry.getName())) {
                        new File(filePath + FILE_SEP + jarEntry.getName()).mkdirs();
                        continue;
                    }
                    fos = FileUtils.openOutputStream(new File(filePath + FILE_SEP + jarEntry.getName()));
                    Throwable throwable = null;
                    try {
                        FileUtils.copyStream(jis, fos);
                        if (fos == null) continue;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                fos.close();
            }
        }
    }

    public static void compressZip(String pathName, String zipName, boolean isRoot) throws IOException {
        try (FileOutputStream fos = FileUtils.openOutputStream(new File(zipName));
             ZipOutputStream out = new ZipOutputStream(fos);){
            String root;
            File file = new File(pathName);
            String string = root = isRoot ? file.getName() + FILE_SEP : "";
            if (file.isDirectory()) {
                CompressUtils.zipDir(out, file, root);
            } else {
                CompressUtils.zipFile(out, file, "");
            }
        }
    }

    private static void zipDir(ZipOutputStream out, File file, String root) throws IOException {
        File[] files = file.listFiles();
        if (files.length < 1) {
            ZipEntry zipEntry = new ZipEntry(root + FILE_SEP);
            out.putNextEntry(zipEntry);
            out.closeEntry();
        }
        for (int i = 0; i < files.length; ++i) {
            String tmpRoot = root;
            if (files[i].isDirectory()) {
                tmpRoot = tmpRoot + files[i].getName() + FILE_SEP;
                CompressUtils.zipDir(out, files[i], tmpRoot);
                continue;
            }
            CompressUtils.zipFile(out, files[i], tmpRoot);
        }
    }

    private static void zipFile(ZipOutputStream out, File file, String root) throws IOException {
        ZipEntry zipEntry = new ZipEntry(root + file.getName());
        out.putNextEntry(zipEntry);
        try (FileInputStream is = new FileInputStream(file);){
            FileUtils.copyStream(is, out);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deCompressZip(String zipName, String filePath) throws IOException {
        File file = new File(zipName);
        if (!file.exists()) {
            throw new UtilRuntimeException(String.format(THE_DECOMPRESSED_PACKAGE_NOT_EXIST_EX, "zip", file.getAbsolutePath()));
        }
        FileUtils.openFileDir(filePath);
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipName));){
            while (true) {
                FileOutputStream fos;
                block25: {
                    ZipEntry zipEntry;
                    if ((zipEntry = zis.getNextEntry()) == null) {
                        return;
                    }
                    if (zipEntry.isDirectory() || "".equals(zipEntry.getName())) {
                        new File(filePath + FILE_SEP + zipEntry.getName()).mkdirs();
                        continue;
                    }
                    fos = FileUtils.openOutputStream(new File(filePath + zipEntry.getName()));
                    Throwable throwable = null;
                    try {
                        FileUtils.copyStream(zis, fos);
                        if (fos == null) continue;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                fos.close();
            }
        }
    }

    public static void compressGZip(String sourceFilePath, String gzipFilePath) throws IOException {
        try (FileInputStream fis = FileUtils.openInputStream(new File(sourceFilePath));
             FileOutputStream fos = FileUtils.openOutputStream(new File(gzipFilePath));
             GZIPOutputStream gos = new GZIPOutputStream(fos);){
            FileUtils.copyStream(fis, gos);
        }
    }

    public static byte[] compressGZipData(byte[] bytes) throws IOException {
        byte[] writeBytes;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             GZIPOutputStream gos = new GZIPOutputStream(bos);){
            gos.write(bytes);
            writeBytes = bos.toByteArray();
        }
        return writeBytes;
    }

    public static void deCompressGZip(String gzipFilePath, String targetFilePath) throws IOException {
        try (FileInputStream fis = FileUtils.openInputStream(new File(gzipFilePath));
             GZIPInputStream gis = new GZIPInputStream(fis);
             FileOutputStream fos = FileUtils.openOutputStream(new File(targetFilePath));){
            FileUtils.copyStream(gis, fos);
        }
    }

    public static byte[] deCompressGZipData(byte[] bytes) throws IOException {
        byte[] b;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
             GZIPInputStream gis = new GZIPInputStream(bis);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] buf = new byte[1024];
            int n = 0;
            while ((n = gis.read(buf)) != -1) {
                bos.write(buf, 0, n);
            }
            b = bos.toByteArray();
        }
        return b;
    }

    public static byte[] compressZipData(byte[] bytes) throws IOException {
        byte[] writeBytes;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ZipOutputStream zop = new ZipOutputStream(bos);){
            ZipEntry entry = new ZipEntry("zop");
            entry.setSize(bytes.length);
            zop.putNextEntry(entry);
            zop.write(bytes);
            zop.closeEntry();
            writeBytes = bos.toByteArray();
        }
        return writeBytes;
    }

    /*
     * Exception decompiling
     */
    public static byte[] deCompressZipData(byte[] bytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

