/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric;

import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.CryptoException;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.SecureUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric.BaseAsymmetric;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric.SignAlgorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;

public class Sign
extends BaseAsymmetric<Sign> {
    protected Signature signature;

    public Sign(SignAlgorithm algorithm) {
        this(algorithm, null, (byte[])null);
    }

    public Sign(String algorithm) {
        this(algorithm, null, (byte[])null);
    }

    public Sign(SignAlgorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(algorithm.getValue(), SecureUtils.decode(privateKeyStr), SecureUtils.decode(publicKeyStr));
    }

    public Sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Sign(SignAlgorithm algorithm, KeyPair keyPair) {
        this(algorithm.getValue(), keyPair);
    }

    public Sign(SignAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Sign(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decodeBase64(privateKeyBase64), Base64.decodeBase64(publicKeyBase64));
    }

    public Sign(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, SecureUtils.generatePrivateKey(algorithm, privateKey), SecureUtils.generatePublicKey(algorithm, publicKey));
    }

    public Sign(String algorithm, KeyPair keyPair) {
        this(algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public Sign(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    @Override
    public Sign init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        super.init(algorithm, privateKey, publicKey);
        return this;
    }

    public Sign setParameter(AlgorithmParameterSpec params) {
        try {
            this.signature.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] sign(byte[] data) {
        this.lock.lock();
        try {
            this.signature.initSign(this.privateKey);
            this.signature.update(data);
            byte[] byArray = this.signature.sign();
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        this.lock.lock();
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data);
            boolean bl = this.signature.verify(sign);
            return bl;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Sign setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Sign setCertificate(Certificate certificate) {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && CollectionUtils.nonEmpty(critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) && critSet.contains("2.5.29.15") && (keyUsageInfo = cert.getKeyUsage()) != null && !keyUsageInfo[0]) {
            throw new CryptoException("Wrong key usage");
        }
        this.publicKey = certificate.getPublicKey();
        return this;
    }
}

