/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt;

import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class ThreeDESUtils {
    public static final String DES_TOOL_CLASS_ERROR = "3DES tool class error";
    private static final String DESEDE = "desede";
    private static final String ECB = "/ECB/PKCS5Padding";
    private static final String CBC = "/CBC/PKCS5Padding";

    private ThreeDESUtils() {
    }

    public static byte[] des3EncodeECB(byte[] key, byte[] data) {
        SecretKey deskey = null;
        try {
            DESedeKeySpec spec = new DESedeKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DESEDE);
            deskey = keyFactory.generateSecret(spec);
            Cipher cipher = Cipher.getInstance("desede/ECB/PKCS5Padding");
            cipher.init(1, deskey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new UtilRuntimeException(DES_TOOL_CLASS_ERROR, e);
        }
    }

    public static byte[] des3DecodeECB(byte[] key, byte[] data) {
        SecretKey deskey = null;
        try {
            DESedeKeySpec spec = new DESedeKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DESEDE);
            deskey = keyFactory.generateSecret(spec);
            Cipher cipher = Cipher.getInstance("desede/ECB/PKCS5Padding");
            cipher.init(2, deskey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new UtilRuntimeException(DES_TOOL_CLASS_ERROR, e);
        }
    }

    public static byte[] des3EncodeCBC(byte[] key, byte[] keyiv, byte[] data) {
        SecretKey deskey = null;
        try {
            DESedeKeySpec spec = new DESedeKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DESEDE);
            deskey = keyFactory.generateSecret(spec);
            Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
            IvParameterSpec ips = new IvParameterSpec(keyiv);
            cipher.init(1, (Key)deskey, ips);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new UtilRuntimeException(DES_TOOL_CLASS_ERROR, e);
        }
    }

    public static byte[] des3DecodeCBC(byte[] key, byte[] keyiv, byte[] data) {
        SecretKey deskey = null;
        try {
            DESedeKeySpec spec = new DESedeKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DESEDE);
            deskey = keyFactory.generateSecret(spec);
            Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
            IvParameterSpec ips = new IvParameterSpec(keyiv);
            cipher.init(2, (Key)deskey, ips);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new UtilRuntimeException(DES_TOOL_CLASS_ERROR, e);
        }
    }
}

