/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt;

import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.encrypt.KeyStoreUtils;
import cn.com.yusys.yusp.commons.util.encrypt.RSAUtils;
import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SHA1WithRSASign {
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final char[] bcdLookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String sign(byte[] content, String privateKey) throws GeneralSecurityException {
        PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKey));
        KeyFactory keyf = KeyFactory.getInstance("RSA");
        PrivateKey priKey = keyf.generatePrivate(priPKCS8);
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initSign(priKey);
        signature.update(content);
        byte[] signed = signature.sign();
        return Base64.encodeBase64String(signed);
    }

    public static boolean doCheck(byte[] content, String sign, String publicKey) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] encodedKey = Base64.decodeBase64(publicKey);
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initVerify(pubKey);
        signature.update(content);
        return signature.verify(Base64.decodeBase64(sign));
    }

    public static String[] getGenKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = null;
        keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = Base64.encodeBase64String(publicKey.getEncoded());
        String privateKeyString = Base64.encodeBase64String(privateKey.getEncoded());
        return new String[]{publicKeyString, privateKeyString};
    }

    public static String encryptData(byte[] data, String keyStorePathString, String keyStorePwd, String keyPwd, String alias) throws Exception {
        PrivateKey privateKey = KeyStoreUtils.getPrivateKeyFromJks(keyStorePathString, keyStorePwd, keyPwd, alias);
        return SHA1WithRSASign.encryptByPrivateKey(data, privateKey);
    }

    public static String signData(byte[] data, String keyStorePathString, String keyStorePwd, String keyPwd, String alias) {
        PrivateKey privateKey = KeyStoreUtils.getPrivateKeyFromJks(keyStorePathString, keyStorePwd, keyPwd, alias);
        return SHA1WithRSASign.signByPrivateKey(data, privateKey);
    }

    public static byte[] decryptData(String signedData, String encryptedData, String cerPath) throws CertificateException, IOException {
        PublicKey publicKey = KeyStoreUtils.getPublicKeyFromCert(cerPath);
        return SHA1WithRSASign.verifyData(signedData, encryptedData, publicKey);
    }

    public static String encryptByPrivateKey(byte[] data, PrivateKey privateKey) {
        byte[] encodedData = RSAUtils.encryptByPrivateKey(data, privateKey);
        return Base64.encodeBase64String(encodedData);
    }

    public static byte[] decryptByPublicKey(String data, PublicKey publicKey) {
        byte[] decodedData = Base64.decodeBase64(data);
        return RSAUtils.decryptByPublicKey(decodedData, publicKey);
    }

    public static String signByPrivateKey(byte[] data, PrivateKey privateKey) {
        byte[] signedData = RSAUtils.signByPrivateKey(data, privateKey);
        return Base64.encodeBase64String(signedData);
    }

    public static boolean verifyByPublicKey(byte[] data, String signData, PublicKey publicKey) {
        byte[] decodedData = Base64.decodeBase64(signData);
        return RSAUtils.verifyByPublicKey(data, decodedData, publicKey);
    }

    public static byte[] verifyData(String signedData, String encryptedData, PublicKey publicKey) {
        boolean flag;
        byte[] decryptedData = SHA1WithRSASign.decryptByPublicKey(encryptedData, publicKey);
        if (signedData != null && !(flag = SHA1WithRSASign.verifyByPublicKey(decryptedData, signedData, publicKey))) {
            throw new UtilRuntimeException("\u6570\u636e\u9a8c\u7b7e\u5931\u8d25");
        }
        return decryptedData;
    }

    public static String bytesToHexStr(byte[] bcd) {
        StringBuilder s = new StringBuilder(bcd.length * 2);
        for (byte b : bcd) {
            s.append(bcdLookup[b >>> 4 & 0xF]);
            s.append(bcdLookup[b & 0xF]);
        }
        return s.toString();
    }
}

