/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanMap;

public class BeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);

    private BeanUtils() {
    }

    @Deprecated
    public static BeanUtils getInstance() {
        return BeanUtilsHolder.INSTANCE;
    }

    public static <T> T newInstance(Class<T> classType) {
        try {
            return classType.newInstance();
        }
        catch (Exception e) {
            log.error("Class[" + classType + "]Exception in instantiation!", (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(Class<T> classType, Class<?>[] constructorType, Object[] params) {
        try {
            return classType.getConstructor(constructorType).newInstance(params);
        }
        catch (Exception e) {
            log.error("Class[" + classType + "]Exception in instantiation!", (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            log.error("Class[" + className + "]Exception in instantiation!", (Throwable)e);
            return null;
        }
    }

    public static BeanInfo getBeanInfo(Class<?> clz) throws IntrospectionException {
        return Introspector.getBeanInfo(clz);
    }

    @Deprecated
    public static List<Field> findAllFields(Class<?> clazz) {
        return ReflectionUtils.getFields(clazz);
    }

    public Object getObjectFieldValue(Object obj, String fieldName) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor descriptor = this.getFieldProperty(obj.getClass(), fieldName);
        return Objects.nonNull(descriptor) ? descriptor.getReadMethod().invoke(obj, new Object[0]) : null;
    }

    public PropertyDescriptor getFieldProperty(Class<?> clz, String fieldName) throws IntrospectionException {
        return Arrays.stream(BeanUtils.getBeanInfo(clz).getPropertyDescriptors()).filter(propertyDescriptor -> propertyDescriptor.getName().equals(fieldName)).findFirst().orElse(null);
    }

    @Deprecated
    public static <T> T getObjectFieldValueByField(Object obj, String fieldName) {
        return ReflectionUtils.getPropertyValue(obj, fieldName);
    }

    @Deprecated
    public static <T> T getObjectFieldValueByField(Object obj, Field field) {
        return ReflectionUtils.getPropertyValue(obj, field);
    }

    @Deprecated
    public static Field getObjectFiled(Object bean, String name) throws Exception {
        return BeanUtils.getObjectFiled(bean.getClass(), name);
    }

    @Deprecated
    public static final Field getObjectFiled(Class<?> clazz, String name) throws Exception {
        return ReflectionUtils.getDeclaredField(clazz, name);
    }

    @Deprecated
    public static Object getObjectFieldValue(Object object, Field field) {
        return ReflectionUtils.getPropertyValue(object, field);
    }

    @Deprecated
    public static Object getObjectFieldValue(Object object, String clazzName, String fieldName) {
        return ReflectionUtils.getPropertyValue(object, clazzName, fieldName);
    }

    public void setFieldValueByWriteMethod(Object obj, String fieldName, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor propertyDescriptor = this.getFieldProperty(obj.getClass(), fieldName);
        propertyDescriptor.getWriteMethod().invoke(obj, value);
    }

    @Deprecated
    public static void setObjectFieldValue(Object object, Field field, Object value) {
        ReflectionUtils.setPropertyValue(object, field, value);
    }

    public static <T extends Annotation> T findAnnotation(Field field, Class<T> annotationClass) {
        return field.getAnnotation(annotationClass);
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClass) {
        return clazz.getAnnotation(annotationClass);
    }

    public static <T extends Annotation> boolean hasAnnotation(Class<?> clazz, Class<T> annotationClass) {
        return clazz.isAnnotationPresent(annotationClass);
    }

    public static <T> T beanCopy(Object source, T target) {
        if (Objects.nonNull(target) && Objects.nonNull(source)) {
            BeanCopier beanCopier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
            beanCopier.copy(source, target, null);
            return target;
        }
        return null;
    }

    public static <T> T beanCopy(Object source, Class<T> target) {
        if (Objects.nonNull(target)) {
            return BeanUtils.beanCopy(source, BeanUtils.newInstance(target));
        }
        return null;
    }

    public static <T> T beanCopy(Object source, Class<T> target, Map<Class<?>, Class<?>> innerClassReflections) {
        if (Objects.nonNull(target) && Objects.nonNull(source)) {
            BeanCopier beanCopier = BeanCopier.create(source.getClass(), target, (boolean)CollectionUtils.nonEmpty(innerClassReflections));
            return BeanUtils.copy(beanCopier, source, target, innerClassReflections);
        }
        return null;
    }

    private static <T> T copy(BeanCopier beanCopier, Object source, Class<T> target, Map<Class<?>, Class<?>> innerClassReflections) {
        T t = BeanUtils.newInstance(target);
        beanCopier.copy(source, t, (innerSource, innerClassType, innerSetMethodName) -> {
            if (innerClassReflections.containsKey(innerSource.getClass()) && innerClassType.equals(innerClassReflections.get(innerSource.getClass()))) {
                return BeanUtils.beanCopy(innerSource, innerClassType, innerClassReflections);
            }
            return innerSource;
        });
        return t;
    }

    public static <T> List<T> beansCopy(Collection<?> source, Class<T> target, Map<Class<?>, Class<?>> innerClassReflections) {
        if (Objects.isNull(source) || Objects.isNull(target)) {
            return null;
        }
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        BeanCopier beanCopier = BeanCopier.create(source.iterator().next().getClass(), target, (boolean)CollectionUtils.nonEmpty(innerClassReflections));
        return source.stream().map(s -> BeanUtils.copy(beanCopier, s, target, innerClassReflections)).collect(Collectors.toList());
    }

    public static <T> List<T> beansCopy(Collection<?> source, Class<T> target) {
        return BeanUtils.beansCopy(source, target, null);
    }

    public static Map<?, ?> beanToMap(Object bean) {
        return BeanMap.create((Object)bean);
    }

    public static <T> T mapToBean(Map<?, ?> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    @Deprecated
    public static List<Field> getAllFieldsList(Class<?> cls) {
        return ReflectionUtils.getFields(cls);
    }

    @Deprecated
    private static class BeanUtilsHolder {
        private static final BeanUtils INSTANCE = new BeanUtils();

        private BeanUtilsHolder() {
        }
    }
}

