/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.lang.Nullable;

public class MessageUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageUtils.class);
    private static final ResourceBundleMessageSource RESOURCE_BUNDLE = new ResourceBundleMessageSource();
    private static final HashMap<String, Locale> LOCALS = new HashMap();
    private static final Locale DEFAULT_LOCALE = Locale.SIMPLIFIED_CHINESE;
    private static final String BASE_FOLDER = "messages";
    private static final String KEY_WORDS = "_msg";
    private static final String PATH = "classpath*:messages/*_msg*.properties";

    public static String getMessage(String messageCode, String defaultMessage, String langCode, Object ... args) {
        return RESOURCE_BUNDLE.getMessage(messageCode, args, defaultMessage, LOCALS.getOrDefault(langCode, DEFAULT_LOCALE));
    }

    public static String getMessage(String messageCode, @Nullable Object[] args, @Nullable String defaultMessage, Locale locale) {
        return RESOURCE_BUNDLE.getMessage(messageCode, args, defaultMessage, locale);
    }

    public static String getDefaultMessage(String messageCode, String defaultMessage, Object ... args) {
        return MessageUtils.getMessage(messageCode, args, defaultMessage, LocaleContextHolder.getLocale());
    }

    public static String getMessage(String messageCode, Object ... args) {
        return MessageUtils.getMessage(messageCode, args, null, LocaleContextHolder.getLocale());
    }

    public static String getMessage(String messageCode, @Nullable Object[] args, String langCode) {
        return MessageUtils.getMessage(messageCode, args, null, langCode);
    }

    static {
        try {
            Resource[] resources;
            LOCALS.put(Locale.SIMPLIFIED_CHINESE.toString(), Locale.SIMPLIFIED_CHINESE);
            LOCALS.put(Locale.ENGLISH.toString(), Locale.ENGLISH);
            LOCALS.put(Locale.US.toString(), Locale.US);
            PathMatchingResourcePatternResolver pattern = new PathMatchingResourcePatternResolver();
            HashSet<String> nameList = new HashSet<String>();
            for (Resource re : resources = pattern.getResources(PATH)) {
                String fileName = re.getFilename();
                String baseName = "messages/" + fileName.substring(0, fileName.indexOf(KEY_WORDS) + KEY_WORDS.length());
                if (!nameList.add(baseName)) continue;
                log.info("find .properties file, name={}", (Object)baseName);
            }
            RESOURCE_BUNDLE.setBasenames(nameList.toArray(new String[nameList.size()]));
        }
        catch (Exception e) {
            log.error("find .properties file error", (Throwable)e);
        }
    }
}

