/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.util;

import cn.com.yusys.yusp.commons.module.adapter.query.PageQuery;
import cn.com.yusys.yusp.commons.module.adapter.query.QueryModel;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MybatisPlusUtils {
    private static final IPage<?> emptyPage = new Page();

    private MybatisPlusUtils() {
    }

    public static <T> Wrapper<T> lambdaQuery(Map<String, Object> maps) {
        return MybatisPlusUtils.lambdaQuery(Wrappers.query(), maps);
    }

    public static <T> Wrapper<T> lambdaQuery(AbstractWrapper<T, String, ?> wrapper, Map<String, Object> queryMap) {
        for (String key : queryMap.keySet()) {
            if (key.startsWith("%")) {
                if (key.endsWith("%")) {
                    wrapper.like((Object)StringUtils.underLine((String)StringUtils.substring((String)key, (int)1, (int)(key.length() - 2))), queryMap.get(key));
                    continue;
                }
                wrapper.likeLeft((Object)StringUtils.underLine((String)StringUtils.substring((String)key, (int)1, (int)(key.length() - 1))), queryMap.get(key));
                continue;
            }
            if (key.endsWith("%")) {
                wrapper.likeRight((Object)StringUtils.underLine((String)StringUtils.substring((String)key, (int)0, (int)(key.length() - 2))), queryMap.get(key));
            }
            wrapper.eq((Object)StringUtils.underLine((String)key), queryMap.get(key));
        }
        return wrapper;
    }

    public static <T> IPage<T> ofPage(long page, long size) {
        return new Page(page, size);
    }

    public static <T, E extends IPage<T>> E ofPage(PageQuery pageQuery) {
        long pageNum = Objects.isNull(pageQuery.getPage()) || pageQuery.getPage() < 1L ? 1L : pageQuery.getPage();
        long pageSize = Objects.isNull(pageQuery.getSize()) || pageQuery.getSize() > 10000L ? 10000L : pageQuery.getSize();
        return (E)new Page(pageNum, pageSize);
    }

    public static <T> IPage<T> ofPage(QueryModel model) {
        if (Objects.nonNull(model)) {
            return new Page((long)model.getPage(), (long)model.getSize());
        }
        return new Page();
    }

    public static <T> Wrapper<T> pageQueryWrapper(Object object) {
        if (Objects.isNull(object)) {
            return Wrappers.emptyWrapper();
        }
        Class stopClassType = object instanceof PageQuery ? PageQuery.class : Object.class;
        List fieldList = ReflectionUtils.getFields(object.getClass(), stopClassType);
        HashMap params = new HashMap(fieldList.size());
        fieldList.forEach(field -> params.put(field.getName(), ReflectionUtils.getPropertyValue((Object)object, (Field)field)));
        return MybatisPlusUtils.lambdaQuery(CollectionUtils.removeNullValue(params));
    }

    public static <T, E extends IPage<T>> E emptyPage() {
        return (E)emptyPage;
    }
}

