/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.injector;

import cn.com.yusys.yusp.commons.mybatisplus.injector.DeleteByIdExtension;
import cn.com.yusys.yusp.commons.mybatisplus.injector.DeleteOne;
import cn.com.yusys.yusp.commons.mybatisplus.injector.ICustomSqlInjector;
import cn.com.yusys.yusp.commons.mybatisplus.injector.SelectByIdExtension;
import cn.com.yusys.yusp.commons.mybatisplus.injector.SqlInjectorExtension;
import cn.com.yusys.yusp.commons.mybatisplus.injector.UpdateByIdExtension;
import cn.com.yusys.yusp.commons.mybatisplus.injector.UpdateExtension;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.injector.methods.DeleteById;
import com.baomidou.mybatisplus.core.injector.methods.SelectById;
import com.baomidou.mybatisplus.core.injector.methods.Update;
import com.baomidou.mybatisplus.core.injector.methods.UpdateById;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlInjectorExtension
extends DefaultSqlInjector
implements SqlInjectorExtension {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSqlInjectorExtension.class);
    static final Map<Class<?>, List<TableFieldInfo>> TABLE_ID_EX_CACHE = new ConcurrentHashMap();
    static final Map<Class<? extends AbstractMethod>, AbstractMethod> EX_REPLACE_MAPPING = new ConcurrentHashMap<Class<? extends AbstractMethod>, AbstractMethod>();
    private final List<ICustomSqlInjector> INJECTORS;

    public DefaultSqlInjectorExtension(List<ICustomSqlInjector> iCustomSqlInjectors) {
        this.INJECTORS = iCustomSqlInjectors;
    }

    public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        Class modelClass = this.extractModelClass(mapperClass);
        if (modelClass != null) {
            this.modelClassValidate(modelClass);
            String className = mapperClass.toString();
            Set mapperRegistryCache = GlobalConfigUtils.getMapperRegistryCache((Configuration)builderAssistant.getConfiguration());
            if (!mapperRegistryCache.contains(className)) {
                List<AbstractMethod> methodList = this.getMethodList(mapperClass);
                if (CollectionUtils.isNotEmpty(methodList)) {
                    TableInfo tableInfo = TableInfoHelper.initTableInfo((MapperBuilderAssistant)builderAssistant, (Class)modelClass);
                    methodList.forEach(m -> m.inject(builderAssistant, mapperClass, modelClass, tableInfo));
                } else {
                    logger.debug(mapperClass.toString() + ", No effective injection method was found.");
                }
                mapperRegistryCache.add(className);
            }
        }
    }

    public List<AbstractMethod> getMethodList(Class<?> mapperClass) {
        List<AbstractMethod> methods = ListUtils.newArrayList(METHOD_MAPPING.values());
        methods = methods.parallelStream().map(this::extensionReplace).collect(Collectors.toList());
        methods.add(new DeleteOne());
        if (CommonUtils.nonNullOrEmpty(this.INJECTORS)) {
            for (ICustomSqlInjector sqlInjector : this.INJECTORS) {
                if (!sqlInjector.isSupported(mapperClass)) continue;
                methods.addAll(sqlInjector.getMethodList(mapperClass));
            }
        }
        return methods;
    }

    private AbstractMethod extensionReplace(AbstractMethod method) {
        if (EX_REPLACE_MAPPING.containsKey(method.getClass())) {
            return EX_REPLACE_MAPPING.get(method.getClass());
        }
        return method;
    }

    static {
        EX_REPLACE_MAPPING.put(DeleteById.class, (AbstractMethod)new DeleteByIdExtension());
        EX_REPLACE_MAPPING.put(SelectById.class, (AbstractMethod)new SelectByIdExtension());
        EX_REPLACE_MAPPING.put(UpdateById.class, (AbstractMethod)new UpdateByIdExtension());
        EX_REPLACE_MAPPING.put(Update.class, (AbstractMethod)new UpdateExtension());
    }
}

