/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.apollo;

import cn.com.yusys.yusp.commons.config.apollo.namespace.DefaultNamespaceListenerRegister;
import cn.com.yusys.yusp.commons.config.apollo.namespace.JsonNamespaceListenerRegister;
import cn.com.yusys.yusp.commons.config.apollo.namespace.NamespaceListenerRegister;
import cn.com.yusys.yusp.commons.config.core.AbstractConfigTemplate;
import cn.com.yusys.yusp.commons.config.core.ChangeEvent;
import cn.com.yusys.yusp.commons.config.core.ChangeItem;
import cn.com.yusys.yusp.commons.config.core.ChangeListener;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.spi.SpiUtils;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloConfigTemplate
extends AbstractConfigTemplate<ConfigChangeEvent, ConfigChangeListener> {
    private static final Logger log = LoggerFactory.getLogger(ApolloConfigTemplate.class);
    private List<NamespaceListenerRegister> namespaceListenerRegisters;

    public void addListener(String dataId, Set<String> interestedKeys, ChangeListener listener) {
        this.parseExtension(dataId);
        if (interestedKeys == null) {
            interestedKeys = Collections.emptySet();
        }
        Config config = ConfigService.getConfig((String)dataId);
        NamespaceListenerRegister register = this.getNamespaceListenerRegister(dataId);
        Asserts.nonNull((Object)register, (String[])new String[]{"Namespace listener register must not null!"});
        ConfigChangeListener changeListener = register.getConfigChangeListener(this, dataId, interestedKeys, listener);
        this.listenerMap.putIfAbsent(listener, changeListener);
        if (interestedKeys.isEmpty()) {
            config.addChangeListener(changeListener);
        } else {
            config.addChangeListener(changeListener, register.getInterestedKeys(interestedKeys));
        }
    }

    private NamespaceListenerRegister getNamespaceListenerRegister(String dataId) {
        if (CollectionUtils.isEmpty(this.namespaceListenerRegisters)) {
            LinkedList<NamespaceListenerRegister> registers = new LinkedList<NamespaceListenerRegister>();
            List spiRegisters = SpiUtils.getSpis(NamespaceListenerRegister.class);
            if (CollectionUtils.nonEmpty((Collection)spiRegisters)) {
                registers.addAll(spiRegisters);
            }
            registers.add(new DefaultNamespaceListenerRegister());
            registers.add(new JsonNamespaceListenerRegister());
            this.namespaceListenerRegisters = Collections.unmodifiableList(registers);
        }
        return this.namespaceListenerRegisters.stream().filter(register -> register.isSupported(dataId)).findFirst().orElse(null);
    }

    public void addListener(String dataId, ChangeListener listener) {
        String extension = this.parseExtension(dataId);
        if ("properties".equals(extension)) {
            this.addListener(dataId, Collections.emptySet(), listener);
        } else {
            Config config = ConfigService.getConfig((String)dataId);
            ConfigChangeListener changeListener = event -> {
                ChangeEvent target = this.transform(dataId, event, Collections.emptySet());
                try {
                    listener.onChange(target);
                }
                catch (RuntimeException e) {
                    log.error("onChange of {} invoke failure, dataId:{}", listener.getClass(), (Object)dataId);
                    throw e;
                }
            };
            config.addChangeListener(changeListener);
            this.listenerMap.putIfAbsent(listener, changeListener);
        }
    }

    public boolean removeListener(String dataId, ChangeListener changeListener) {
        return this.doRemoveListener(dataId, changeListener, (data, listener) -> Optional.ofNullable(ConfigService.getConfig((String)data)).ifPresent(config -> config.removeChangeListener(listener)));
    }

    public boolean publishProperty(String dataId, String key, String value) {
        throw new UnsupportedOperationException("Unsupported operation!");
    }

    public boolean publishConfig(String dataId, String value) {
        throw new UnsupportedOperationException("Unsupported operation!");
    }

    public String getConfig(String dataId) {
        throw new UnsupportedOperationException("Unsupported operation!");
    }

    public String getProperty(String dataId, String key, String defaultValue) {
        Config config = ConfigService.getConfig((String)dataId);
        return config.getProperty(key, defaultValue);
    }

    public ChangeEvent transform(String dataId, ConfigChangeEvent source, Set<String> interestedKeys) {
        ChangeEvent target = new ChangeEvent();
        Set changedKeys = source.changedKeys();
        for (String changeKey : changedKeys) {
            if (!interestedKeys.isEmpty() && !interestedKeys.contains(changeKey)) continue;
            ChangeItem targetChange = new ChangeItem();
            ConfigChange sourceChange = source.getChange(changeKey);
            targetChange.setDataId(sourceChange.getNamespace()).setPropertyName(sourceChange.getPropertyName()).setOldValue(sourceChange.getOldValue()).setNewValue(sourceChange.getNewValue()).setChangeType(sourceChange.getChangeType().name());
            target.addChange(changeKey, targetChange);
        }
        return target;
    }
}

