/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatis.key;

import cn.com.yusys.yusp.commons.mybatis.annotation.IdentitySequence;
import cn.com.yusys.yusp.commons.mybatis.key.Sequence;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SequenceGenerator {
    private static final Map<Class<?>, String> SEQUENCE_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, BiFunction<Long, Object, String>> FORMATTER_CACHE = new ConcurrentHashMap();
    private final ExpressionParser parser = new SpelExpressionParser();
    private final Sequence sequence;

    public SequenceGenerator(Sequence sequence) {
        Asserts.nonNull((Object)sequence, (String[])new String[]{"Sequence must not null!"});
        this.sequence = sequence;
    }

    public Number nextId(Object entity, Class<?> entityClass) {
        return this.sequence.nextId(SEQUENCE_CACHE.computeIfAbsent(entityClass, this::getSequenceName));
    }

    public String nextUUID(Object entity, Class<?> entityClass) {
        String expr = entityClass.getAnnotation(IdentitySequence.class).format();
        if (StringUtils.isEmpty((CharSequence)expr)) {
            return this.sequence.nextUUID(SEQUENCE_CACHE.computeIfAbsent(entityClass, this::getSequenceName));
        }
        long seed = this.getSeed(entity);
        return (String)FORMATTER_CACHE.computeIfAbsent(entityClass, this::formatter).apply(seed, entity);
    }

    private Long getSeed(Object entity) {
        return this.sequence.nextId(SEQUENCE_CACHE.computeIfAbsent(entity.getClass(), this::getSequenceName));
    }

    private String getSequenceName(Class<?> entityClass) {
        return entityClass.getAnnotation(IdentitySequence.class).value();
    }

    private BiFunction<Long, Object, String> formatter(Class<?> entity) {
        String expr = entity.getAnnotation(IdentitySequence.class).format();
        if (StringUtils.isEmpty((CharSequence)expr)) {
            return (l, o) -> l.toString();
        }
        Expression expression = this.parser.parseExpression(expr);
        return (l, o) -> {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject(o);
            context.setVariable("seed", (Object)new LongSeed((Long)l));
            return (String)expression.getValue((EvaluationContext)context, String.class);
        };
    }

    public static class LongSeed
    extends Number {
        private static final long serialVersionUID = -1L;
        private final Long value;

        public LongSeed(Long value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value.intValue();
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value.floatValue();
        }

        @Override
        public double doubleValue() {
            return this.value.doubleValue();
        }

        public String pad(int size) {
            return StringUtils.leftPad((String)Long.toString(this.value), (int)size, (char)'0');
        }
    }
}

