/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.start;

import cn.com.yusys.yusp.commons.module.start.AppMessages;
import cn.com.yusys.yusp.commons.module.start.AppMessagesService;
import java.net.InetAddress;
import java.util.Objects;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;

public class BootStartMessagesService
implements AppMessagesService {
    @Override
    public AppMessages loadAppMessages(ApplicationContext context) {
        AppMessages message = new AppMessages();
        String serviceName = context.getEnvironment().getProperty("spring.application.name");
        message.setServiceName(serviceName);
        String protocol = "http";
        ServerProperties server = (ServerProperties)context.getBean(ServerProperties.class);
        if (server.getSsl() != null && server.getSsl().getKeyStore() != null) {
            protocol = "https";
        }
        Integer port = server.getPort();
        String ip = this.getActualIP();
        message.setProtocol(protocol);
        message.setIp(ip);
        message.setPort(Objects.nonNull(port) ? port : 8080);
        String[] profiles = context.getEnvironment().getActiveProfiles();
        message.setProfiles(profiles);
        return message;
    }

    protected String getActualIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            return "127.0.0.1";
        }
    }
}

