/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.license;

import cn.com.yusys.license.LicenseManager;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;

public final class ApplicationLicenseListener
implements ApplicationListener<ApplicationContextInitializedEvent>,
Ordered {
    private final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass().getName());
    private static AtomicInteger cur = new AtomicInteger(0);
    private static AtomicBoolean checked = new AtomicBoolean(false);
    private final String bootstrap = "org.springframework.cloud.bootstrap.BootstrapApplicationListener";
    private static final String PRODUCT_CODE = "0000001122";
    private static final String EXPEND_INFO = "YUDP";
    private Environment env;
    private String licenseModel = "PRO";
    private String licenseFile;
    private String licenseContext;
    private LicenseManager lManager = LicenseManager.getInstance();

    public void onApplicationEvent(ApplicationContextInitializedEvent event) {
        if (this.isBootStrap((Environment)event.getApplicationContext().getEnvironment()) && cur.get() == 0) {
            cur.incrementAndGet();
        } else if (checked.compareAndSet(false, true) && !this.validateLicense((Environment)event.getApplicationContext().getEnvironment())) {
            System.exit(0);
        }
    }

    boolean isBootStrap(Environment env) {
        return ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.BootstrapApplicationListener", null) && (Boolean)env.getProperty("spring.cloud.bootstrap.enabled", Boolean.class, (Object)true) != false;
    }

    private boolean validateLicense(Environment env) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage();
            }
        });
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(consoleHandler);
        this.env = env;
        boolean check = true;
        try {
            this.setLicenseConfig();
            this.logger.info("License authorization succeeded:" + this.lManager.initialize(PRODUCT_CODE, EXPEND_INFO));
        }
        catch (Throwable e) {
            this.logger.severe("License verification failed! Exception information:" + e.getMessage() + System.getProperty("line.separator"));
            check = false;
        }
        return check;
    }

    private void setLicenseConfig() {
        String licenseMacFile = "";
        this.licenseModel = this.env.getProperty("license.licenseModel") == null ? this.licenseModel : this.env.getProperty("license.licenseModel");
        this.licenseContext = this.env.getProperty("license.licenseContext");
        this.licenseFile = this.env.getProperty("license.licenseFile");
        if (StringUtils.isEmpty((CharSequence)this.licenseContext) && StringUtils.isEmpty((CharSequence)this.licenseFile)) {
            try {
                Files.find(Paths.get(Thread.currentThread().getContextClassLoader().getResource("").toURI()), 1, (path, basicFileAttributes) -> path.getFileName().toString().matches("^YTEC-\\d{10}-\\d-\\d{10}.lic$"), new FileVisitOption[0]).findFirst().ifPresent(path -> {
                    this.licenseFile = path.toString();
                    this.lManager.setLicenseFile(this.licenseFile);
                });
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        licenseMacFile = this.env.getProperty("license.licenseMacFile");
        this.lManager.setLicenseModel(this.licenseModel);
        InputStream inputStream = null;
        if (this.licenseContext != null && !"".equals(this.licenseContext)) {
            inputStream = this.getLicContextInputStream(this.licenseContext);
        } else if (StringUtils.nonEmpty((CharSequence)this.licenseFile)) {
            inputStream = this.getLicFileInputStream(this.licenseFile);
        } else {
            throw new RuntimeException("License file:" + this.licenseFile + "read exception!!!");
        }
        this.lManager.setMacFile(licenseMacFile);
        this.lManager.setInputStream(inputStream);
    }

    private InputStream getLicContextInputStream(String licenseContext) {
        return new ByteArrayInputStream(licenseContext.getBytes());
    }

    private InputStream getLicFileInputStream(String licenseFile) {
        InputStream inputStream;
        File tf = new File(licenseFile);
        if (tf.exists()) {
            try {
                inputStream = new FileInputStream(tf);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("License file:" + licenseFile + "read exception!!!");
            }
        }
        try {
            ClassPathResource resource = new ClassPathResource(licenseFile);
            inputStream = resource.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException("License file:" + licenseFile + "does not exist!!!");
        }
        return inputStream;
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

