/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.config;

import cn.com.yusys.yusp.commons.module.Module;
import cn.com.yusys.yusp.commons.module.ModuleHelper;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class ModuleRefreshScopeBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ModuleRefreshScopeBeanDefinitionRegistryPostProcessor.class);
    private static final String REFRESH_SCOPE = "refresh";

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ModuleHelper.modules().forEach(module -> this.setModuleRefreshScopeSupport((Module)module, registry));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    void setModuleRefreshScopeSupport(Module module, BeanDefinitionRegistry registry) {
        String propertiesClasses = module.getProperty().getClasses();
        if (StringUtils.nonEmpty((CharSequence)propertiesClasses)) {
            String[] classTypes = StringUtils.split((String)propertiesClasses, (String)",");
            Arrays.stream(classTypes).map(StringUtils::trim).filter(StringUtils::nonEmpty).forEach(classType -> this.setModuleRefreshScopeSupport(module.getName(), (String)classType, registry));
        } else {
            logger.warn("Current module [{}] not exist need dynamic refresh class!", (Object)module.getName());
        }
    }

    void setModuleRefreshScopeSupport(String moduleName, String classType, BeanDefinitionRegistry registry) {
        try {
            BeanDefinition beanDefinition = registry.getBeanDefinition(classType);
            beanDefinition.setScope(REFRESH_SCOPE);
            ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)new BeanDefinitionHolder(beanDefinition, classType), (BeanDefinitionRegistry)registry, (boolean)true);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn("Config module [{}] need dynamic refresh properties bean [{}] not exist!", (Object)moduleName, (Object)classType);
        }
    }
}

