/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module;

import cn.com.yusys.yusp.commons.module.Module;
import cn.com.yusys.yusp.commons.module.ModuleHelper;
import cn.com.yusys.yusp.commons.util.PropertiesUtils;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

public class ModuleApplicationListener
implements GenericApplicationListener {
    private static final String MODULE_INFO_LOCATION = "module.info";
    private static final Class<?>[] EVENT_TYPES = new Class[]{ApplicationStartingEvent.class};
    private static final Class<?>[] SOURCE_TYPES = new Class[]{SpringApplication.class, ApplicationContext.class};

    public boolean supportsEventType(ResolvableType eventType) {
        return this.isAssignableFrom(eventType.getRawClass(), EVENT_TYPES);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return this.isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    private boolean isAssignableFrom(Class<?> type, Class<?> ... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        List<Module> modules;
        if (event instanceof ApplicationStartingEvent && !ModuleHelper.hasRegister() && !(modules = PropertiesUtils.loadProperties(MODULE_INFO_LOCATION, Module.class)).isEmpty()) {
            ModuleHelper.register(modules);
        }
    }

    public int getOrder() {
        return -2147483618;
    }
}

