/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.i18n;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MessageUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageUtils.class);
    private static final ResourceBundleMessageSource resourceBundle = new ResourceBundleMessageSource();
    private static final HashMap<String, Locale> locals = new HashMap();
    private static final Locale defaultLocale = Locale.SIMPLIFIED_CHINESE;
    private static final String baseFolder = "messages";
    private static final String keyWords = "_msg";
    private static final String path = "classpath*:messages/*_msg*.properties";

    public static String getMessage(String messageCode, String defaultMessage, String langCode, Object ... args) {
        return resourceBundle.getMessage(messageCode, args, defaultMessage, locals.getOrDefault(langCode, defaultLocale));
    }

    static {
        try {
            Resource[] resources;
            locals.put(Locale.SIMPLIFIED_CHINESE.toString(), Locale.SIMPLIFIED_CHINESE);
            locals.put(Locale.ENGLISH.toString(), Locale.ENGLISH);
            locals.put(Locale.US.toString(), Locale.US);
            PathMatchingResourcePatternResolver pattern = new PathMatchingResourcePatternResolver();
            HashSet<String> nameList = new HashSet<String>();
            for (Resource re : resources = pattern.getResources(path)) {
                String fileName = re.getFilename();
                String baseName = "messages/" + fileName.substring(0, fileName.indexOf(keyWords) + keyWords.length());
                if (!nameList.add(baseName)) continue;
                log.info("find .properties file, name={}", (Object)baseName);
            }
            resourceBundle.setBasenames(nameList.toArray(new String[nameList.size()]));
        }
        catch (Exception e) {
            log.error("find .properties file error", (Throwable)e);
        }
    }
}

