/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.enchance;

import cn.com.yusys.yusp.commons.redis.YuspRedisCache;
import cn.com.yusys.yusp.commons.redis.enchance.CacheOpThreadLocal;
import cn.com.yusys.yusp.commons.redis.enchance.CacheOpWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.DurationValueWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.YuspCacheTransactionSynchronization;
import cn.com.yusys.yusp.commons.redis.util.RedisUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class YuspCacheDecorator
implements Cache {
    private static final Logger logger = LoggerFactory.getLogger(YuspCacheDecorator.class);
    public static final String CACHE_UPDATE_HOLDER = "@CACHE_UPDATE";
    public static final String EVICT_UPDATE_HOLDER = "@CACHE_EVICT";
    private final YuspRedisCache targetCache;

    public YuspCacheDecorator(Cache targetCache) {
        Assert.notNull((Object)targetCache, (String)"Target Cache must not be null");
        this.targetCache = (YuspRedisCache)targetCache;
    }

    public String getName() {
        return this.targetCache.getName();
    }

    public Object getNativeCache() {
        return this.targetCache.getNativeCache();
    }

    public <T> T get(Object key, Class<T> type) {
        Cache.ValueWrapper wrapper = this.get(key);
        return wrapper == null ? null : (T)type.cast(wrapper.get());
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.targetCache.get(key, valueLoader);
        if (value == null || YuspCacheDecorator.isWrite(value) || YuspCacheDecorator.isEvict(value)) {
            try {
                value = valueLoader.call();
                this.targetCache.put(key, value);
            }
            catch (Exception e) {
                throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
            }
        }
        return (T)value;
    }

    public Cache.ValueWrapper get(Object key) {
        Map<String, CacheOpWrapper> transactionCaches;
        String realKey = this.targetCache.getRealKey(key);
        if (TransactionSynchronizationManager.isSynchronizationActive() && (transactionCaches = this.registerTransactionSynchronization()).containsKey(realKey)) {
            CacheOpWrapper value = transactionCaches.get(realKey);
            if (CacheOpWrapper.CacheOpType.REMOVE == value.getCacheOpType()) {
                return null;
            }
            return value;
        }
        Cache.ValueWrapper wrapper = this.targetCache.get(key);
        if (null == wrapper || null == wrapper.get()) {
            CacheOpWrapper cacheOp = new CacheOpWrapper(this.getName(), null, CacheOpWrapper.CacheOpType.READ, true);
            CacheOpThreadLocal.CacheOps.get().put(realKey, cacheOp);
            return null;
        }
        if (YuspCacheDecorator.isWrite(wrapper.get()) || YuspCacheDecorator.isEvict(wrapper.get())) {
            CacheOpWrapper cacheOp = new CacheOpWrapper(this.getName(), null, CacheOpWrapper.CacheOpType.READ, false);
            CacheOpThreadLocal.CacheOps.get().put(realKey, cacheOp);
            return null;
        }
        return wrapper;
    }

    public void put(Object key, Object value) {
        if (null == value) {
            return;
        }
        String realKey = this.targetCache.getRealKey(key);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Map<String, CacheOpWrapper> transactionCaches = this.registerTransactionSynchronization();
            CacheOpWrapper cacheOp = transactionCaches.get(realKey);
            if (null != cacheOp && cacheOp.getCacheOpType() == CacheOpWrapper.CacheOpType.REMOVE) {
                CacheOpWrapper cacheOpT = new CacheOpWrapper(this.getName(), null, CacheOpWrapper.CacheOpType.REMOVE, true);
                transactionCaches.put(realKey, cacheOpT);
            } else if (CacheOpThreadLocal.CacheOps.get().containsKey(realKey)) {
                CacheOpWrapper cacheOpT = new CacheOpWrapper(this.getName(), value, CacheOpWrapper.CacheOpType.READ, CacheOpThreadLocal.CacheOps.get().get(realKey).isOp());
                transactionCaches.put(realKey, cacheOpT);
                CacheOpThreadLocal.CacheOps.get().remove(realKey);
            } else {
                CacheOpWrapper cacheOpT = new CacheOpWrapper(this.getName(), value, CacheOpWrapper.CacheOpType.WRITE, true);
                transactionCaches.put(realKey, cacheOpT);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Setting value into transactionCaches[key = {}, valueType = {} ].", key, (Object)value.getClass().getSimpleName());
            }
        } else {
            CacheOpWrapper cacheOp = CacheOpThreadLocal.CacheOps.get().get(realKey);
            if (null != cacheOp && cacheOp.getCacheOpType() == CacheOpWrapper.CacheOpType.READ) {
                try {
                    this.targetCache.putIfAbsent(key, value);
                }
                catch (Exception e) {
                    this.onThrowable(e);
                }
            } else {
                this.targetCache.put(key, value);
            }
        }
    }

    public void evict(Object key) {
        String realKey = this.targetCache.getRealKey(key);
        if (key instanceof Collection) {
            for (Object itemKey : (Collection)key) {
                this.evict(itemKey);
            }
            return;
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Map<String, CacheOpWrapper> transactionCaches = this.registerTransactionSynchronization();
            CacheOpWrapper cacheOpT = new CacheOpWrapper(this.getName(), null, CacheOpWrapper.CacheOpType.REMOVE, true);
            transactionCaches.put(realKey, cacheOpT);
            if (logger.isDebugEnabled()) {
                logger.debug("Delete value from transactionCaches[ key = {} ].", key);
            }
        } else {
            String holderValue = RedisUtils.randomPrefix(EVICT_UPDATE_HOLDER);
            DurationValueWrapper durationWrapper = new DurationValueWrapper(holderValue, "30S");
            this.targetCache.put(key, durationWrapper);
            if (logger.isDebugEnabled()) {
                logger.debug("Setting evict holder value to cache[ key = {} ].", key);
            }
        }
    }

    public void clear() {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Map<String, CacheOpWrapper> transactionCaches = this.registerTransactionSynchronization();
            CacheOpWrapper cacheOpT = new CacheOpWrapper(this.getName(), null, CacheOpWrapper.CacheOpType.CLEAR, true);
            transactionCaches.put(this.getName() + ":", cacheOpT);
        }
        this.targetCache.clear();
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        this.put(key, value);
        return null;
    }

    public static boolean isWrite(Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            return strValue.startsWith(CACHE_UPDATE_HOLDER);
        }
        return false;
    }

    public static boolean isEvict(Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            return strValue.startsWith(EVICT_UPDATE_HOLDER);
        }
        return false;
    }

    private Map<String, CacheOpWrapper> registerTransactionSynchronization() {
        HashMap<String, CacheOpWrapper> caches = (HashMap<String, CacheOpWrapper>)TransactionSynchronizationManager.getResource((Object)((Object)this.targetCache));
        if (caches == null) {
            caches = new HashMap<String, CacheOpWrapper>();
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new YuspCacheTransactionSynchronization(this.targetCache, caches));
            TransactionSynchronizationManager.bindResource((Object)((Object)this.targetCache), caches);
        }
        return caches;
    }

    protected void onThrowable(Throwable t) {
        logger.warn("Cache operate exception. ", t);
    }
}

