/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis;

import cn.com.yusys.yusp.commons.redis.YuspRedisCache;
import cn.com.yusys.yusp.commons.redis.enchance.YuspCacheDecorator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class YuspRedisCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final RedisCacheWriter cacheWriter;
    private final RedisCacheConfiguration defaultCacheConfig;
    private final Map<String, RedisCacheConfiguration> initialCacheConfiguration;
    private final boolean allowInFlightCacheCreation;

    protected Cache decorateCache(Cache cache) {
        return new YuspCacheDecorator(cache);
    }

    private YuspRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowInFlightCacheCreation) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
        this.initialCacheConfiguration = new LinkedHashMap<String, RedisCacheConfiguration>();
        this.allowInFlightCacheCreation = allowInFlightCacheCreation;
    }

    public YuspRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowInFlightCacheCreation) {
        this(cacheWriter, defaultCacheConfiguration, allowInFlightCacheCreation);
        Assert.notNull(initialCacheConfigurations, (String)"InitialCacheConfigurations must not be null!");
        this.initialCacheConfiguration.putAll(initialCacheConfigurations);
    }

    protected Collection<RedisCache> loadCaches() {
        LinkedList<RedisCache> caches = new LinkedList<RedisCache>();
        for (Map.Entry<String, RedisCacheConfiguration> entry : this.initialCacheConfiguration.entrySet()) {
            caches.add(this.createRedisCache(entry.getKey(), entry.getValue()));
        }
        return caches;
    }

    protected RedisCache getMissingCache(String name) {
        return this.allowInFlightCacheCreation ? this.createRedisCache(name, this.defaultCacheConfig) : null;
    }

    protected YuspRedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        return new YuspRedisCache(name, this.cacheWriter, cacheConfig != null ? cacheConfig : this.defaultCacheConfig);
    }

    public RedisCacheWriter getCacheWriter() {
        return this.cacheWriter;
    }

    public RedisCacheConfiguration getDefaultCacheConfig() {
        return this.defaultCacheConfig;
    }
}

