/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis;

import cn.com.yusys.yusp.commons.redis.YuspRedisCacheLuaScript;
import cn.com.yusys.yusp.commons.redis.YuspRedisCacheWriter;
import cn.com.yusys.yusp.commons.redis.enchance.AbsentValueWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.CasValueWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.DurationValueWrapper;
import cn.com.yusys.yusp.commons.redis.util.RedisUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.core.script.DigestUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class YuspRedisCache
extends RedisCache {
    private static final Logger logger = LoggerFactory.getLogger(YuspRedisCache.class);
    private final ConversionService conversionService;

    public YuspRedisCache(String name, RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
        super(name, cacheWriter, cacheConfig);
        this.conversionService = cacheConfig.getConversionService();
    }

    public void put(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            throw new IllegalArgumentException(String.format("Cache '%s' does not allow 'null' values. Avoid storing null via '@Cacheable(unless=\"#result == null\")' or configure RedisCache to allow 'null' via RedisCacheConfiguration.", this.getName()));
        }
        if (logger.isInfoEnabled()) {
            logger.info("Setting value into cache[key={}]", key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("value is [{}]", cacheValue);
        }
        if (cacheValue instanceof CasValueWrapper) {
            CasValueWrapper casValue = (CasValueWrapper)cacheValue;
            Object expectValue = casValue.getExpectValue();
            cacheValue = casValue.get();
            YuspRedisCacheWriter writer = (YuspRedisCacheWriter)this.getNativeCache();
            byte[][] keysAndArgs = new byte[][]{this.serializeCacheKey(this.createCacheKey(key)), this.serializeCacheValue(cacheValue), this.serializeCacheValue(expectValue)};
            Duration time = this.getCacheConfiguration().getTtl();
            if (expectValue instanceof String && expectValue.toString().startsWith("@CACHE_EVICT")) {
                time = RedisUtils.getDuration("30S");
            }
            String sha1 = DigestUtils.sha1DigestAsHex((String)"local v1 = redis.call('get',KEYS[1])\nif (v1 == ARGV[2]) then \n    redis.call('set',KEYS[1],ARGV[1])\nend\n");
            writer.casPut(this.getName(), YuspRedisCacheLuaScript.scriptBytes(sha1), YuspRedisCacheLuaScript.scriptBytes("local v1 = redis.call('get',KEYS[1])\nif (v1 == ARGV[2]) then \n    redis.call('set',KEYS[1],ARGV[1])\nend\n"), time, keysAndArgs);
        } else if (cacheValue instanceof DurationValueWrapper) {
            DurationValueWrapper durationValue = (DurationValueWrapper)cacheValue;
            Duration ttl = RedisUtils.getDuration(durationValue.getDuration());
            this.getNativeCache().put(this.getName(), this.serializeCacheKey(this.createCacheKey(key)), this.serializeCacheValue(durationValue.get()), ttl);
        } else if (cacheValue instanceof AbsentValueWrapper) {
            this.getNativeCache().putIfAbsent(this.getName(), this.serializeCacheKey(this.createCacheKey(key)), this.serializeCacheValue(((AbsentValueWrapper)cacheValue).get()), this.getCacheConfiguration().getTtl());
        } else {
            this.getNativeCache().put(this.getName(), this.serializeCacheKey(this.createCacheKey(key)), this.serializeCacheValue(cacheValue), this.getCacheConfiguration().getTtl());
        }
    }

    public String convertKey(Object key) {
        TypeDescriptor source = TypeDescriptor.forObject((Object)key);
        if (this.conversionService.canConvert(source, TypeDescriptor.valueOf(String.class))) {
            return (String)this.conversionService.convert(key, String.class);
        }
        Method toString = ReflectionUtils.findMethod(key.getClass(), (String)"toString");
        if (toString != null && !Object.class.equals(toString.getDeclaringClass())) {
            return key.toString();
        }
        throw new IllegalStateException(String.format("Cannot convert %s to String. Register a Converter or override toString().", source));
    }

    public String getRealKey(Object key) {
        return this.getName() + ":" + this.convertKey(key);
    }
}

