/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.template.freemarker;

import cn.com.yusys.yusp.commons.freemarker.FreeMarkerTemplate;
import cn.com.yusys.yusp.commons.freemarker.serivce.FreeMarkerService;
import freemarker.template.Configuration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={FreeMarkerTemplate.class, FreeMarkerService.class})
@ConditionalOnProperty(name={"spring.freemarker.enable"}, havingValue="true", matchIfMissing=true)
public class YuspFreemarkerAutoConfiguration {
    @Bean
    public FreeMarkerTemplate freeMarkerTemplate(Configuration configuration) {
        configuration.setAPIBuiltinEnabled(true);
        return new FreeMarkerTemplate(configuration);
    }

    @Bean
    public FreeMarkerService freeMarkerService(FreeMarkerTemplate freeMarkerTemplate, @Value(value="${spring.freemarker.file-loader-path:}") String fileLoaderPath) {
        return new FreeMarkerService(freeMarkerTemplate, fileLoaderPath);
    }
}

