/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.session;

import cn.com.yusys.yusp.commons.session.SessionService;
import cn.com.yusys.yusp.commons.session.support.CacheableCleanSessionService;
import cn.com.yusys.yusp.commons.session.support.CacheableSessionService;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={SessionService.class, CacheableSessionService.class})
@ConditionalOnProperty(prefix="spring.cache", name={"type"}, havingValue="redis")
public class SessionBeanProxyAutoConfiguration {
    @Bean
    public SessionBeanDefinitionRegistryPostProcessor sessionBeanDefinitionRegistryPostProcessor() {
        return new SessionBeanDefinitionRegistryPostProcessor();
    }

    static class SessionBeanDefinitionRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        SessionBeanDefinitionRegistryPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (registry instanceof ListableBeanFactory) {
                ListableBeanFactory factory = (ListableBeanFactory)registry;
                Object[] beanNames = factory.getBeanNamesForType(SessionService.class);
                if (ArrayUtils.nonEmpty((Object[])beanNames)) {
                    boolean isMultiBean = beanNames.length > 1;
                    long primaryCount = Stream.of(beanNames).map(arg_0 -> ((BeanDefinitionRegistry)registry).getBeanDefinition(arg_0)).filter(BeanDefinition::isPrimary).count();
                    if (isMultiBean && primaryCount != 1L) {
                        throw new BeanCreationException("There are currently multiple SessionService, please specify a unique SessionService object!");
                    }
                    Stream.of(beanNames).forEach(beanName -> this.reRegistryBean(registry, (String)beanName, isMultiBean));
                } else {
                    this.registryBean(registry);
                }
                this.registryCleanBean(registry);
            }
        }

        void reRegistryBean(BeanDefinitionRegistry registry, String beanName, boolean isMultiBean) {
            String delegateBeanName = StringUtils.builder0((Object[])new Object[]{beanName, "$Proxy"});
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            beanDefinition.setPrimary(false);
            registry.registerBeanDefinition(delegateBeanName, beanDefinition);
            registry.removeBeanDefinition(beanName);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CacheableSessionService.class);
            builder.addConstructorArgReference(delegateBeanName);
            builder.setPrimary(!isMultiBean || beanDefinition.isPrimary());
            registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
        }

        void registryBean(BeanDefinitionRegistry registry) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CacheableSessionService.class);
            builder.addConstructorArgValue(null);
            registry.registerBeanDefinition(CacheableSessionService.class.getName(), (BeanDefinition)builder.getBeanDefinition());
        }

        void registryCleanBean(BeanDefinitionRegistry registry) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CacheableCleanSessionService.class);
            registry.registerBeanDefinition(CacheableCleanSessionService.class.getName(), (BeanDefinition)builder.getBeanDefinition());
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

