/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.entity;

import cn.com.yusys.yusp.commons.mapper.util.MapperUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import javax.persistence.Table;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathEntityScanner
extends ClassPathBeanDefinitionScanner {
    private Class<? extends Annotation> annotationClass = Table.class;

    public ClassPathEntityScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void registerFilters() {
        if (this.annotationClass != null) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotationClass));
        }
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            if (className.endsWith("package-info")) {
                return true;
            }
            return !metadataReader.getAnnotationMetadata().hasAnnotation(Table.class.getName());
        });
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        for (String basePackage : basePackages) {
            Set beanDefinitions = super.findCandidateComponents(basePackage);
            if (beanDefinitions == null || beanDefinitions.isEmpty()) {
                this.logger.warn((Object)("No Entity was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
                continue;
            }
            this.processBeanDefinitions(beanDefinitions);
        }
        return null;
    }

    private void processBeanDefinitions(Set<BeanDefinition> beanDefinitions) {
        beanDefinitions.forEach(beanDefinition -> MapperUtils.addEntity((String)beanDefinition.getBeanClassName()));
    }
}

