/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis;

import cn.com.yusys.yusp.commons.autoconfigure.mybatis.PageHelperProperties;
import cn.com.yusys.yusp.commons.mybatis.key.Sequence;
import cn.com.yusys.yusp.commons.mybatis.key.SequenceAdapter;
import cn.com.yusys.yusp.commons.mybatis.logger.SqlExecutorLoggerInterceptor;
import cn.com.yusys.yusp.commons.mybatis.logger.SqlLoggerInterceptor;
import cn.com.yusys.yusp.commons.mybatis.pagehelper.OracleDialectAdapter;
import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import com.github.pagehelper.PageInterceptor;
import com.github.pagehelper.page.PageAutoDialect;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement(proxyTargetClass=true)
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
public class MybatisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.setProperty("Oracle", "oracle");
        properties.setProperty("MySQL", "mysql");
        properties.setProperty("DB2", "DB2");
        properties.setProperty("DM DBMS", "oracle");
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }

    @Configuration
    @ConditionalOnClass(name={"com.github.pagehelper.PageHelper", "cn.com.yusys.yusp.commons.mybatis.pagehelper.OracleDialectAdapter"})
    @AutoConfigureBefore(value={PageConfiguration.class}, name={"com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration"})
    public static class PageHelperAdapterAutoConfiguration {
        public PageHelperAdapterAutoConfiguration() {
            PageAutoDialect.registerDialectAlias((String)"oracle", OracleDialectAdapter.class);
            PageAutoDialect.registerDialectAlias((String)"dm", OracleDialectAdapter.class);
            PageAutoDialect.registerDialectAlias((String)"edb", OracleDialectAdapter.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Sequence.class, SequenceUtils.class})
    public static class SequenceAdapterConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public Sequence sequenceAdapter() {
            return new SequenceAdapter();
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={PageHelperProperties.class})
    @ConditionalOnClass(name={"com.github.pagehelper.PageHelper"})
    @ConditionalOnMissingClass(value={"com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration"})
    public static class PageConfiguration {
        private final PageHelperProperties properties;

        public PageConfiguration(PageHelperProperties properties) {
            this.properties = properties;
        }

        @Bean
        @Order(value=-11)
        @ConditionalOnMissingBean
        public PageInterceptor pageInterceptor() {
            PageInterceptor interceptor = new PageInterceptor();
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.properties.getProperties());
            interceptor.setProperties(properties);
            return interceptor;
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, SqlLoggerInterceptor.class, SqlExecutorLoggerInterceptor.class})
    static class SqlLoggerInterceptorAutoConfiguration {
        SqlLoggerInterceptorAutoConfiguration() {
        }

        @Deprecated
        @Bean
        @Order(value=9)
        @ConditionalOnProperty(prefix="yusp", name={"mybatis.sql-log.version"}, havingValue="V1")
        public Interceptor sqlLoggerInterceptor() {
            return new SqlLoggerInterceptor();
        }

        @Bean
        @ConditionalOnProperty(prefix="yusp", name={"mybatis.sql-log.version"}, havingValue="V2", matchIfMissing=true)
        public Interceptor SqlExecutorLoggerInterceptor() {
            return new SqlExecutorLoggerInterceptor();
        }
    }
}

