/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.file;

import cn.com.yusys.yusp.commons.autoconfigure.file.FileProperties;
import cn.com.yusys.yusp.commons.file.client.AbstractFileClient;
import cn.com.yusys.yusp.commons.file.client.ConnectConfig;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateFactory;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateRegister;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public interface FileClientRegister {
    public void register(BeanDefinitionRegistry var1, Environment var2, List<FileSystemTemplateRegister> var3, FileProperties var4);

    public static abstract class AbstractFileClientRegister
    implements FileClientRegister {
        protected <T extends ConnectConfig, C extends AbstractFileClient<T>> void register(BeanDefinitionRegistry registry, Class<C> fileClientClassType, List<T> configs, FileProperties.ConnectionPool<?> connectionPool, List<FileSystemTemplateRegister> fileSystemTemplateRegisters, Consumer<BeanDefinitionBuilder> fileClientConsumer) {
            if (CollectionUtils.nonEmpty(configs)) {
                for (ConnectConfig config : configs) {
                    BeanDefinitionBuilder clientBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(fileClientClassType);
                    clientBeanBuilder.addConstructorArgValue((Object)config.getClientName());
                    clientBeanBuilder.addConstructorArgValue((Object)config);
                    clientBeanBuilder.addConstructorArgValue(connectionPool);
                    clientBeanBuilder.addPropertyValue("homePath", (Object)config.getHomePath());
                    if (Objects.nonNull(fileClientConsumer)) {
                        fileClientConsumer.accept(clientBeanBuilder);
                    }
                    registry.registerBeanDefinition(config.getClientName(), (BeanDefinition)clientBeanBuilder.getBeanDefinition());
                    BeanDefinitionBuilder templateBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileSystemTemplateFactory.class);
                    templateBeanBuilder.addConstructorArgReference(config.getClientName());
                    templateBeanBuilder.addConstructorArgValue(fileSystemTemplateRegisters);
                    templateBeanBuilder.addConstructorArgValue((Object)config.getDefaultPath());
                    registry.registerBeanDefinition(config.getTemplateName(), (BeanDefinition)templateBeanBuilder.getBeanDefinition());
                }
            }
        }

        protected <T> List<T> listBind(Environment environment, Class<T> classType, String prefix) {
            Binder binder = Binder.get((Environment)environment);
            BindResult bindResult = binder.bind(prefix, Bindable.listOf(classType));
            return (List)bindResult.orElseGet(Collections::emptyList);
        }

        protected <T> T objectBind(Environment environment, Class<T> classType, String prefix) {
            Binder binder = Binder.get((Environment)environment);
            BindResult bindResult = binder.bind(prefix, Bindable.of(classType));
            return (T)bindResult.orElse(null);
        }
    }
}

