/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.config;

import cn.com.yusys.yusp.commons.config.annotation.ChangeListenerAnnotationBeanPostProcessor;
import cn.com.yusys.yusp.commons.config.annotation.ChangeListenerAnnotationManager;
import cn.com.yusys.yusp.commons.config.annotation.DataIdConverter;
import cn.com.yusys.yusp.commons.config.annotation.ItemChangeListenerRegister;
import cn.com.yusys.yusp.commons.config.annotation.MultiItemChangeListenerRegister;
import cn.com.yusys.yusp.commons.config.annotation.SingleItemChangeListenerRegister;
import cn.com.yusys.yusp.commons.config.boot.ChangeListenerApplicationRunner;
import cn.com.yusys.yusp.commons.config.core.ConfigTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ChangeListenerAnnotationManager.class})
@ConditionalOnBean(value={ConfigTemplate.class})
public class ConfigAutoConfiguration {
    @Bean
    public ItemChangeListenerRegister changeListenerRegister(Environment environment) {
        String type = environment.getProperty("yusp.config.item-listener-type", "single");
        if ("single".equals(type)) {
            return new SingleItemChangeListenerRegister();
        }
        return new MultiItemChangeListenerRegister();
    }

    @Bean
    public ChangeListenerAnnotationManager changeListenerAnnotationManage(ItemChangeListenerRegister itemChangeListenerRegister, ConfigTemplate template) {
        return new ChangeListenerAnnotationManager(itemChangeListenerRegister, template);
    }

    @Bean
    public ChangeListenerAnnotationBeanPostProcessor changeListenerAnnotationBeanPostProcessor(ChangeListenerAnnotationManager manager, @Autowired(required=false) DataIdConverter dataIdConverter) {
        return new ChangeListenerAnnotationBeanPostProcessor(manager, dataIdConverter);
    }

    @Bean
    public ChangeListenerApplicationRunner changeListenerApplicationRunner() {
        return new ChangeListenerApplicationRunner();
    }
}

