/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web;

import cn.com.yusys.yusp.commons.exception.web.handler.ExceptionHandler;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionTranslator {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionTranslator.class);
    private final List<ExceptionHandler<?>> exceptionHandlers;

    public ExceptionTranslator(List<ExceptionHandler<?>> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object processException(Exception e) throws Exception {
        logger.error(e.getMessage(), (Throwable)e);
        if (CollectionUtils.isEmpty(this.exceptionHandlers)) {
            return null;
        }
        for (ExceptionHandler<?> exceptionHandler : this.exceptionHandlers) {
            if (!exceptionHandler.isSupported(e)) continue;
            exceptionHandler.tag(e);
            if (logger.isDebugEnabled()) {
                logger.debug("class {} to handler exception {}", exceptionHandler, (Object)e.getClass().toString());
            }
            return exceptionHandler.handleException(e);
        }
        throw e;
    }
}

