/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.io;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.HexUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.io.FastByteArrayOutputStream;
import cn.com.yusys.yusp.commons.util.io.NullOutputStream;
import cn.com.yusys.yusp.commons.util.io.StreamProgress;
import cn.com.yusys.yusp.commons.util.io.ValidateObjectInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IOUtils.copy(reader, writer, 8192);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        return IOUtils.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws IOException {
        int readSize;
        char[] buffer = new char[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        while ((readSize = reader.read(buffer, 0, bufferSize)) != -1) {
            writer.write(buffer, 0, readSize);
            size += (long)readSize;
            writer.flush();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IOUtils.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        return IOUtils.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IOException {
        int readSize;
        Asserts.nonNull(in, "InputStream is null !");
        Asserts.nonNull(out, "OutputStream is null !");
        if (bufferSize <= 0) {
            bufferSize = 8192;
        }
        byte[] buffer = new byte[bufferSize];
        if (null != streamProgress) {
            streamProgress.start();
        }
        long size = 0L;
        while ((readSize = in.read(buffer)) != -1) {
            out.write(buffer, 0, readSize);
            size += (long)readSize;
            out.flush();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IOException {
        return IOUtils.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, streamProgress);
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IOException {
        long l;
        Asserts.nonNull(in, "FileInputStream is null!");
        Asserts.nonNull(out, "FileOutputStream is null!");
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.close(outChannel);
                IOUtils.close(inChannel);
                throw throwable;
            }
        }
        IOUtils.close(outChannel);
        IOUtils.close(inChannel);
        return l;
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws IOException {
        return IOUtils.copy(in, out, 8192);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws IOException {
        return IOUtils.copy(in, out, bufferSize, null);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws IOException {
        Asserts.nonNull(in, "InputStream is null !");
        Asserts.nonNull(out, "OutputStream is null !");
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize <= 0 ? 8192 : bufferSize);
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        while (in.read(byteBuffer) != -1) {
            byteBuffer.flip();
            size += (long)out.write(byteBuffer);
            byteBuffer.clear();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static BufferedReader getUtf8Reader(InputStream in) {
        return IOUtils.getReader(in, StandardCharsets.UTF_8.name());
    }

    public static BufferedReader getReader(InputStream in, String charsetName) {
        return IOUtils.getReader(in, Charset.forName(charsetName));
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getReader(Reader reader) {
        if (null == reader) {
            return null;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static PushbackReader getPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    public static OutputStreamWriter getUtf8Writer(OutputStream out) {
        return IOUtils.getWriter(out, StandardCharsets.UTF_8.name());
    }

    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        return IOUtils.getWriter(out, Charset.forName(charsetName));
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, String charsetName) throws IOException {
        FastByteArrayOutputStream out = IOUtils.read(in);
        return StringUtils.isBlank(charsetName) ? out.toString() : out.toString(charsetName);
    }

    public static String read(InputStream in, Charset charset) throws IOException {
        FastByteArrayOutputStream out = IOUtils.read(in);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static String read(ReadableByteChannel channel, Charset charset) throws IOException {
        FastByteArrayOutputStream out = IOUtils.read(channel);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IOUtils.copy(in, out);
        return out;
    }

    public static FastByteArrayOutputStream read(ReadableByteChannel channel) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IOUtils.copy(channel, Channels.newChannel(out));
        return out;
    }

    public static String read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        while (-1 != reader.read(buffer)) {
            builder.append(buffer.flip().toString());
        }
        return builder.toString();
    }

    public static String readUtf8(FileChannel fileChannel) throws IOException {
        return IOUtils.read(fileChannel, StandardCharsets.UTF_8.name());
    }

    public static String read(FileChannel fileChannel, String charsetName) throws IOException {
        return IOUtils.read(fileChannel, Charset.forName(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IOException {
        MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        return StringUtils.convert((ByteBuffer)buffer, charset);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        return IOUtils.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean isCloseStream) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IOUtils.copy(in, out);
        if (isCloseStream) {
            IOUtils.close(in);
        }
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, int length) throws IOException {
        if (null == in) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] b = new byte[length];
        int readLength = in.read(b);
        if (readLength > 0 && readLength < length) {
            byte[] b2 = new byte[readLength];
            System.arraycopy(b, 0, b2, 0, readLength);
            return b2;
        }
        return b;
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws IOException {
        return HexUtils.encodeHexStr(IOUtils.readBytes(in, length), toLowerCase);
    }

    public static String readHex28Upper(InputStream in) throws IOException {
        return IOUtils.readHex(in, 28, false);
    }

    public static String readHex28Lower(InputStream in) throws IOException {
        return IOUtils.readHex(in, 28, true);
    }

    public static <T> T readObj(InputStream in) throws IOException, ClassNotFoundException {
        return IOUtils.readObj(in, null);
    }

    public static <T> T readObj(InputStream in, Class<T> clazz) throws IOException, ClassNotFoundException {
        return IOUtils.readObj(in instanceof ValidateObjectInputStream ? (ValidateObjectInputStream)in : new ValidateObjectInputStream(in, new Class[0]), clazz);
    }

    public static <T> T readObj(ValidateObjectInputStream in, Class<T> clazz) throws IOException, ClassNotFoundException {
        if (in == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        try {
            return (T)in.readObject();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
    }

    public static <T extends Collection<String>> T readUtf8Lines(InputStream in, T collection) throws IOException {
        return IOUtils.readLines(in, StandardCharsets.UTF_8.name(), collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, String charsetName, T collection) throws IOException {
        return IOUtils.readLines(in, Charset.forName(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws IOException {
        return IOUtils.readLines((Reader)IOUtils.getReader(in, charset), collection);
    }

    public static <T extends Collection<String>> T readLines(Reader reader, T collection) throws IOException {
        IOUtils.readLines(reader, collection::add);
        return collection;
    }

    public static void readUtf8Lines(InputStream in, Consumer<String> lineHandler) throws IOException {
        IOUtils.readLines(in, StandardCharsets.UTF_8, lineHandler);
    }

    public static void readLines(InputStream in, Charset charset, Consumer<String> lineHandler) throws IOException {
        IOUtils.readLines((Reader)IOUtils.getReader(in, charset), lineHandler);
    }

    public static void readLines(Reader reader, Consumer<String> lineHandler) throws IOException {
        String line;
        Asserts.nonNull(reader, new String[0]);
        Asserts.nonNull(lineHandler, new String[0]);
        BufferedReader bReader = IOUtils.getReader(reader);
        if (bReader == null) {
            return;
        }
        while ((line = bReader.readLine()) != null) {
            lineHandler.accept(line);
        }
    }

    public static ByteArrayInputStream toStream(String content, String charsetName) {
        return IOUtils.toStream(content, Charset.forName(charsetName));
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return IOUtils.toStream(StringUtils.bytes((CharSequence)content, charset));
    }

    public static ByteArrayInputStream toUtf8Stream(String content) {
        return IOUtils.toStream(content, StandardCharsets.UTF_8);
    }

    public static FileInputStream toStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static InputStream toMarkSupportStream(InputStream in) {
        if (null == in) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return in;
    }

    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, pushBackSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IOException {
        try {
            out.write(content);
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IOUtils.close(out);
                throw throwable;
            }
        }
        IOUtils.close(out);
        return;
    }

    public static void writeUtf8(OutputStream out, boolean isCloseOut, Object ... contents) throws IOException {
        IOUtils.write(out, StandardCharsets.UTF_8, isCloseOut, contents);
    }

    public static void write(OutputStream out, String charsetName, boolean isCloseOut, Object ... contents) throws IOException {
        IOUtils.write(out, Charset.forName(charsetName), isCloseOut, contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(OutputStream out, Charset charset, boolean isCloseOut, Object ... contents) throws IOException {
        OutputStreamWriter osw = null;
        try {
            osw = IOUtils.getWriter(out, charset);
            Objects.requireNonNull(osw, "OutputStream must not null!");
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Objects.nonNull(contents) ? StringUtils.toString(contents) : "");
            }
            osw.flush();
            if (!isCloseOut) return;
        }
        catch (Throwable throwable) {
            if (!isCloseOut) throw throwable;
            IOUtils.close(osw);
            throw throwable;
        }
        IOUtils.close(osw);
    }

    public static void writeObj(OutputStream out, boolean isCloseOut, Serializable obj) throws IOException {
        IOUtils.writeObjects(out, isCloseOut, obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, boolean isCloseOut, Serializable ... contents) throws IOException {
        ObjectOutputStream osw = null;
        try {
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (Serializable content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
                osw.flush();
            }
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IOUtils.close(osw);
                throw throwable;
            }
        }
        IOUtils.close(osw);
        return;
    }

    public static void flush(Flushable flushable) {
        if (null != flushable) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void close0(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(Closeable ... closeables) {
        if (ArrayUtils.nonEmpty(closeables)) {
            for (Closeable closeable : closeables) {
                IOUtils.close0(closeable);
            }
        }
    }

    public static void close(AutoCloseable ... closeables) {
        if (ArrayUtils.nonEmpty(closeables)) {
            for (AutoCloseable closeable : closeables) {
                IOUtils.close0(closeable);
            }
        }
    }

    private static void close0(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void closeIfPosible(Object obj) {
        if (obj instanceof AutoCloseable) {
            IOUtils.close((AutoCloseable)obj);
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        Asserts.nonNull(input1, "InputStream input1 must not null!");
        Asserts.nonNull(input2, "InputStream input2 must not null!");
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        int ch2;
        Asserts.nonNull(input1, "Reader input1 must not null!");
        Asserts.nonNull(input2, "Reader input2 must not null!");
        input1 = IOUtils.getReader(input1);
        input2 = IOUtils.getReader(input2);
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IOException {
        BufferedReader br1 = IOUtils.getReader(input1);
        BufferedReader br2 = IOUtils.getReader(input2);
        Asserts.nonNull(br1, "Reader input1 must not null!");
        Asserts.nonNull(br2, "Reader input2 must not null!");
        String line1 = br1.readLine();
        String line2 = br2.readLine();
        while (line1 != null && line1.equals(line2)) {
            line1 = br1.readLine();
            line2 = br2.readLine();
        }
        return Objects.equals(line1, line2);
    }

    public static long checksumCRC32(InputStream in) throws IOException {
        return IOUtils.checksum(in, new CRC32()).getValue();
    }

    public static Checksum checksum(InputStream in, Checksum checksum) throws IOException {
        Asserts.nonNull(in, "InputStream is null !");
        if (null == checksum) {
            checksum = new CRC32();
        }
        try {
            in = new CheckedInputStream(in, checksum);
            IOUtils.copy(in, new NullOutputStream());
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return checksum;
    }

    public static long checksumValue(InputStream in, Checksum checksum) throws IOException {
        return IOUtils.checksum(in, checksum).getValue();
    }
}

