/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt.crypto.digest;

import cn.com.yusys.yusp.commons.util.HexUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.CryptoException;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.digest.HmacAlgorithm;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.digest.mac.MacEngine;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.digest.mac.MacEngineFactory;
import cn.com.yusys.yusp.commons.util.io.FileUtils;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

public class HMac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MacEngine engine;

    public HMac(HmacAlgorithm algorithm) {
        this(algorithm, (Key)null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public HMac(HmacAlgorithm algorithm, Key key) {
        this(algorithm.getValue(), key);
    }

    public HMac(String algorithm, byte[] key) {
        this(algorithm, (Key)new SecretKeySpec(key, algorithm));
    }

    public HMac(String algorithm, Key key) {
        this(MacEngineFactory.createEngine(algorithm, key));
    }

    public HMac(MacEngine engine) {
        this.engine = engine;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StringUtils.bytes((CharSequence)data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, StandardCharsets.UTF_8.name());
    }

    public String digestHex(String data, String charset) {
        return HexUtils.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, StandardCharsets.UTF_8.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(file);
            byArray = this.digest(in);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return byArray;
    }

    public String digestHex(File file) {
        return HexUtils.encodeHexStr(this.digest(file));
    }

    public byte[] digest(byte[] data) {
        return this.digest(new ByteArrayInputStream(data), -1);
    }

    public String digestHex(byte[] data) {
        return HexUtils.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexUtils.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        return this.engine.digest(data, bufferLength);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtils.encodeHexStr(this.digest(data, bufferLength));
    }

    public int getMacLength() {
        return this.engine.getMacLength();
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }
}

