/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric;

import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.HexUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.BCD;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.SecureUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric.BaseAsymmetric;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric.KeyType;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class AbstractAsymmetricCrypto<T extends AbstractAsymmetricCrypto<T>>
extends BaseAsymmetric<T> {
    public AbstractAsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public abstract byte[] encrypt(byte[] var1, KeyType var2);

    public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtils.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encodeBase64String(this.encrypt(data, keyType));
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, StandardCharsets.UTF_8), keyType);
    }

    public String encryptHex(String data, KeyType keyType) {
        return HexUtils.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexUtils.encodeHexStr(this.encrypt(data, charset, keyType));
    }

    public String encryptBase64(String data, KeyType keyType) {
        return Base64.encodeBase64String(this.encrypt(data, keyType));
    }

    public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encodeBase64String(this.encrypt(data, charset, keyType));
    }

    public byte[] encrypt(InputStream data, KeyType keyType) throws RuntimeException {
        try {
            return this.encrypt(IOUtils.readBytes(data), keyType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtils.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encodeBase64String(this.encrypt(data, keyType));
    }

    public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, StandardCharsets.UTF_8);
    }

    public String encryptBcd(String data, KeyType keyType, Charset charset) {
        return BCD.bcdToStr(this.encrypt(data, charset, keyType));
    }

    public abstract byte[] decrypt(byte[] var1, KeyType var2);

    public byte[] decrypt(InputStream data, KeyType keyType) throws RuntimeException {
        try {
            return this.decrypt(IOUtils.readBytes(data), keyType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(SecureUtils.decode(data), keyType);
    }

    public String decryptStr(String data, KeyType keyType, Charset charset) {
        return StringUtils.str(this.decrypt(data, keyType), charset);
    }

    public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, StandardCharsets.UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, StandardCharsets.UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType, Charset charset) {
        Asserts.nonNull(data, "Bcd string must be not null!");
        byte[] dataBytes = BCD.ascToBcd(StringUtils.bytes((CharSequence)data, charset));
        return this.decrypt(dataBytes, keyType);
    }

    public String decryptStrFromBcd(String data, KeyType keyType, Charset charset) {
        return StringUtils.str(this.decryptFromBcd(data, keyType, charset), charset);
    }

    public String decryptStrFromBcd(String data, KeyType keyType) {
        return this.decryptStrFromBcd(data, keyType, StandardCharsets.UTF_8);
    }
}

