/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt.crypto;

import cn.com.yusys.yusp.commons.util.encrypt.crypto.CryptoException;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.SMUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.SecureUtils;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class ECKeyUtils {
    public static AsymmetricKeyParameter toParams(Key key) {
        if (key instanceof PrivateKey) {
            return ECKeyUtils.toPrivateParams((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return ECKeyUtils.toPublicParams((PublicKey)key);
        }
        return null;
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] q) {
        return ECKeyUtils.toPublicParams(q, SMUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String q) {
        return ECKeyUtils.toPublicParams(q, SMUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String x, String y) {
        return ECKeyUtils.toPublicParams(x, y, SMUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] xBytes, byte[] yBytes) {
        return ECKeyUtils.toPublicParams(xBytes, yBytes, SMUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toPublicParams(String x, String y, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPublicParams(SecureUtils.decode(x), SecureUtils.decode(y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPublicParams(BigIntegers.fromUnsignedByteArray((byte[])xBytes), BigIntegers.fromUnsignedByteArray((byte[])yBytes), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        if (null == x || null == y) {
            return null;
        }
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtils.toPublicParams(curve.createPoint(x, y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(String pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtils.toPublicParams(curve.decodePoint(SecureUtils.decode(pointEncoded)), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtils.toPublicParams(curve.decodePoint(pointEncoded), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(ECPoint point, ECDomainParameters domainParameters) {
        return new ECPublicKeyParameters(point, domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(PublicKey publicKey) {
        if (null == publicKey) {
            return null;
        }
        try {
            return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(String d) {
        return ECKeyUtils.toPrivateParams(d, SMUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(byte[] d) {
        return ECKeyUtils.toPrivateParams(d, SMUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(BigInteger d) {
        return ECKeyUtils.toPrivateParams(d, SMUtils.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toPrivateParams(String d, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])SecureUtils.decode(d)), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(byte[] d, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])d), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(BigInteger d, ECDomainParameters domainParameters) {
        if (null == d) {
            return null;
        }
        return new ECPrivateKeyParameters(d, domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(PrivateKey privateKey) {
        if (null == privateKey) {
            return null;
        }
        try {
            return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
    }
}

