/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt;

import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.encrypt.SM4;
import cn.com.yusys.yusp.commons.util.encrypt.SM4Context;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class SM4Utils {
    private static final String PATTERN = "\\s*|\t|\r|\n";

    public static String encryptData_ECB(String secretKey, String data, String enCoding, boolean hexString) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = hexString ? NumberUtils.hexToByte(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, data.getBytes(enCoding));
            String cipherText = Base64.encodeBase64String(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile(PATTERN);
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            throw new RuntimeException("SM4 encryption failed", e);
        }
    }

    public static String decryptData_ECB(String secretKey, String data, String enCoding, boolean hexString) throws RuntimeException {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = hexString ? NumberUtils.hexToByte(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64(data));
            return new String(decrypted, enCoding);
        }
        catch (Exception e) {
            throw new RuntimeException("SM4 decryption failed", e);
        }
    }

    public static String encryptData_CBC(String secretKey, String iv, String data, String enCoding, boolean hexString) throws RuntimeException {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (hexString) {
                keyBytes = NumberUtils.hexToByte(secretKey);
                ivBytes = NumberUtils.hexToByte(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, data.getBytes(enCoding));
            String cipherText = Base64.encodeBase64String(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile(PATTERN);
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            throw new RuntimeException("SM4 encryption failed", e);
        }
    }

    public static String decryptData_CBC(String secretKey, String iv, String data, String enCoding, boolean hexString) throws RuntimeException {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (hexString) {
                keyBytes = NumberUtils.hexToByte(secretKey);
                ivBytes = NumberUtils.hexToByte(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64(data));
            return new String(decrypted, enCoding);
        }
        catch (Exception e) {
            throw new RuntimeException("SM4 decryption failed", e);
        }
    }
}

