/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt;

import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.LoggerFactory;

public final class BCRSAUtils {
    private static RSAPublicKey pubKey = null;
    private static RSAPrivateKey priKey = null;
    private static final String DEFAULT_RSA_ALGORITHM = "RSA/None/PKCS1Padding";

    private static Key readKey(String keyName) throws Exception {
        ObjectInputStream keyIn = new ObjectInputStream(BCRSAUtils.class.getClassLoader().getResourceAsStream(keyName));
        Key key = (Key)keyIn.readObject();
        keyIn.close();
        return key;
    }

    public static String decryptByPrivate(String content) throws Exception {
        return new String(BCRSAUtils.decrypt(priKey, Base64.decodeBase64(content)));
    }

    public static String encryptByPub(String key) throws Exception {
        return Base64.encodeBase64String(BCRSAUtils.encryptByPub(key.getBytes(), pubKey.getEncoded()));
    }

    public static byte[] decrypt(Key key, byte[] content) throws Exception {
        Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
        cipher.init(2, key);
        return cipher.doFinal(content);
    }

    public static byte[] encryptByPub(byte[] data, byte[] keyByte) throws Exception {
        KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec pub_spec = new X509EncodedKeySpec(keyByte);
        PublicKey publicKey = mykeyFactory.generatePublic(pub_spec);
        Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPub(byte[] data, String key) throws Exception {
        return BCRSAUtils.encryptByPub(data, Base64.decodeBase64(key));
    }

    public static String encryptByPrivate(String password) throws Exception {
        return Base64.encodeBase64String(BCRSAUtils.encryptByPrivate(password.getBytes(), priKey.getEncoded()));
    }

    public static byte[] encryptByPrivate(byte[] data, byte[] keyByte) throws Exception {
        KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec private_spec = new PKCS8EncodedKeySpec(keyByte);
        PrivateKey privateKey = mykeyFactory.generatePrivate(private_spec);
        Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPrivate(byte[] data, String key) throws Exception {
        return BCRSAUtils.encryptByPrivate(data, Base64.decodeBase64(key));
    }

    public static void createPublicKeyFile(PublicKey key, String filePath) throws Exception {
        KeyRep pubKeyRep = new KeyRep(KeyRep.Type.PUBLIC, key.getAlgorithm(), key.getFormat(), key.getEncoded());
        try (FileOutputStream fos = new FileOutputStream(filePath);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(pubKeyRep);
            oos.flush();
        }
    }

    public static void createPrivateKeyFile(PrivateKey key, String filePath) throws Exception {
        KeyRep priKeyRep = new KeyRep(KeyRep.Type.PRIVATE, key.getAlgorithm(), key.getFormat(), key.getEncoded());
        try (FileOutputStream fos = new FileOutputStream(filePath);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(priKeyRep);
            oos.flush();
        }
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            priKey = (RSAPrivateKey)BCRSAUtils.readKey("cert/pwd_private.key");
            pubKey = (RSAPublicKey)BCRSAUtils.readKey("cert/pwd_public.key");
        }
        catch (Exception err) {
            LoggerFactory.getLogger(BCRSAUtils.class).error(err.getMessage());
        }
    }
}

