/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.date;

import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatUtils {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_DEFAULT);
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_TIME);
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_DATETIME);
    public static final DateTimeFormatter DAY_PATH_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_DAY_PATH);
    public static final DateTimeFormatter TIME_COMPACT_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_TIME_COMPACT);
    public static final DateTimeFormatter DATETIME_COMPACT_SSS_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_DATETIME_COMPACT_SSS);
    public static final DateTimeFormatter DATE_COMPACT_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_DATE_COMPACT);
    public static final DateTimeFormatter DATE_SHORT_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_DATE_SHORT);
    public static final DateTimeFormatter YEAR_MONTH_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_YEAR_MONTH);
    public static final DateTimeFormatter YEAR_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.PATTERN_YEAR);

    private DateFormatUtils() {
    }

    public static LocalDateTime zone(String zone) {
        return LocalDateTime.now(ZoneId.of(zone));
    }

    public static SimpleDateFormat zone(String pattern, String zone) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone(zone));
        return format;
    }

    public static LocalDate localDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static Date date(LocalDate localDate) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        return Date.from(zdt.toInstant());
    }
}

