/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String STRING_ZERROR = "0";
    public static final char CHAR_ZERROR = '0';
    private static final String CHAR_SPACE = " ";
    private static final int PAD_LIMIT = 8192;
    public static final int INDEX_NOT_FOUND = -1;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final String EMPTY = "";
    public static final Pattern EMAIL_PATTER = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
    public static final Pattern NRT_PATTERN = Pattern.compile("\n|\t|\r");
    public static final Pattern LETTER_PATTERN = Pattern.compile("[\\w\\.-_]*");
    public static final String EN_COMMA = ",";

    private StringUtils() throws IllegalAccessException {
        throw new IllegalAccessException("Not instantiable!");
    }

    public static boolean isEmpty(CharSequence cs) {
        return Objects.isNull(cs) || cs.length() == 0;
    }

    public static boolean nonEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String substring(String str, int len) {
        return StringUtils.substring(str, 0, len);
    }

    public static String substring(String str, int startIdx, int len) {
        if (len <= 0 || startIdx < 0 || StringUtils.isEmpty(str)) {
            return EMPTY;
        }
        if (len > str.length() || len - startIdx > str.length()) {
            return str;
        }
        return str.substring(startIdx, startIdx + len);
    }

    public static String substr(String str, int startIdx, int endIdx) {
        return StringUtils.substring(str, startIdx, endIdx - startIdx);
    }

    public static String[] split(String str, String regex) {
        if (StringUtils.isEmpty(str)) {
            return new String[0];
        }
        return str.split(regex, -1);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StringUtils.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StringUtils.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (str1 == str2) {
            return true;
        }
        if (str1 != null) {
            return ignoreCase ? str2 != null && str1.toString().equalsIgnoreCase(str2.toString()) : str1.equals(str2);
        }
        return false;
    }

    public static String replaceObjNull(Object o) {
        return Objects.nonNull(o) ? o.toString() : null;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtils.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!StringUtils.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtils.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence str, char ... testChars) {
        if (!StringUtils.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayUtils.contains(testChars, str.charAt(i))) continue;
                return false;
            }
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static String cleanBlank(CharSequence str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (StringUtils.isBlankChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public static String format(CharSequence template, Object ... params) {
        if (Objects.isNull(template)) {
            return null;
        }
        if (ArrayUtils.isEmpty(params) || StringUtils.isBlank(template)) {
            return template.toString();
        }
        return StringUtils.format(template.toString(), params);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        if (Objects.isNull(template)) {
            return null;
        }
        if (Objects.isNull(map) || map.isEmpty()) {
            return template.toString();
        }
        String template2 = template.toString();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String value = String.valueOf(entry.getValue());
            template2 = template2.replaceAll("\\{" + entry.getKey() + "}", Objects.isNull(value) ? EMPTY : value);
        }
        return template2;
    }

    public static String format(String strPattern, Object ... argArray) {
        if (StringUtils.isBlank(strPattern) || ArrayUtils.isEmpty(argArray)) {
            return strPattern;
        }
        int strPatternLength = strPattern.length();
        StringBuilder sbuf = new StringBuilder(strPatternLength + 50);
        int handledPosition = 0;
        for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
            int delimIndex = strPattern.indexOf("{}", handledPosition);
            if (delimIndex == -1) {
                if (handledPosition == 0) {
                    return strPattern;
                }
                sbuf.append(strPattern, handledPosition, strPatternLength);
                return sbuf.toString();
            }
            if (delimIndex > 0 && strPattern.charAt(delimIndex - 1) == '\\') {
                if (delimIndex > 1 && strPattern.charAt(delimIndex - 2) == '\\') {
                    sbuf.append(strPattern, handledPosition, delimIndex - 1);
                    sbuf.append(StringUtils.utf8Str(argArray[argIndex]));
                    handledPosition = delimIndex + 2;
                    continue;
                }
                --argIndex;
                sbuf.append(strPattern, handledPosition, delimIndex - 1);
                sbuf.append('[');
                handledPosition = delimIndex + 1;
                continue;
            }
            sbuf.append(strPattern, handledPosition, delimIndex);
            sbuf.append(StringUtils.utf8Str(argArray[argIndex]));
            handledPosition = delimIndex + 2;
        }
        sbuf.append(strPattern, handledPosition, strPattern.length());
        return sbuf.toString();
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static String utf8Str(Object obj) {
        return StringUtils.convert(obj, StandardCharsets.UTF_8);
    }

    public static String convert(Object obj, String charsetName) {
        return StringUtils.convert(obj, Charset.forName(charsetName));
    }

    public static String convert(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringUtils.convert((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringUtils.convert((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringUtils.convert((ByteBuffer)obj, charset);
        }
        if (ArrayUtils.isArray(obj)) {
            return ArrayUtils.toString(obj);
        }
        return obj.toString();
    }

    public static String convert(byte[] bytes, String charset) {
        return StringUtils.convert(bytes, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String convert(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String convert(Byte[] bytes, String charset) {
        return StringUtils.convert(bytes, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String convert(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringUtils.convert(bytes, charset);
    }

    public static String convert(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StringUtils.convert(data, Charset.forName(charset));
    }

    public static String convert(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String convert(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String builder(int capacity, Object ... objects) {
        StringBuilder builder = new StringBuilder(capacity > 0 ? capacity : 100);
        if (Objects.nonNull(objects)) {
            Arrays.stream(objects).forEach(builder::append);
        }
        return builder.toString();
    }

    public static String builder0(Object ... objects) {
        return StringUtils.builder(100, objects);
    }

    public static String buffer(int capacity, Object ... objects) {
        StringBuffer buffer = new StringBuffer(capacity > 0 ? capacity : 100);
        if (Objects.nonNull(objects)) {
            Arrays.stream(objects).forEach(s -> buffer.append(s));
        }
        return buffer.toString();
    }

    public static String buffer0(Object ... objects) {
        return StringUtils.buffer(100, objects);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final String concat(String ... strArrays) {
        return StringUtils.concat(strArrays, null, false);
    }

    public static String concat(String[] strArray, String str) {
        return StringUtils.concat(strArray, str, false);
    }

    public static String concat(String[] strArray, String str, boolean isReturnNull) {
        if (Objects.nonNull(strArray) && strArray.length > 0) {
            str = Optional.ofNullable(str).orElse(EMPTY);
            StringBuilder sb = new StringBuilder(strArray.length * 8);
            for (String s : strArray) {
                if (StringUtils.isEmpty(s)) {
                    if (!isReturnNull) continue;
                    sb.append(StringUtils.replaceObjNull(s)).append(str);
                    continue;
                }
                sb.append(s).append(str);
            }
            String returnStr = sb.toString();
            return StringUtils.substring(returnStr, returnStr.length() - str.length());
        }
        return EMPTY;
    }

    public static String concat(Collection<String> collections, String str) {
        return StringUtils.concat(collections, str, false);
    }

    public static String concat(Collection<String> collections, String str, boolean isReturnNull) {
        if (Objects.isNull(collections)) {
            return EMPTY;
        }
        String[] strArray = collections.toArray(new String[collections.size()]);
        return StringUtils.concat(strArray, str, isReturnNull);
    }

    public static String upperCase(String str) {
        return StringUtils.isEmpty(str) ? EMPTY : str.toUpperCase();
    }

    public static String upperCaseFirst(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
        return builder.toString();
    }

    public static String lowerCaseFirst(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        return builder.toString();
    }

    public static final String lowerCase(String str) {
        return StringUtils.isEmpty(str) ? EMPTY : str.toLowerCase();
    }

    public static final String fill(char c, int length) {
        return StringUtils.fill(CharBuffer.wrap(new char[]{c}), length);
    }

    public static final String fill(CharSequence cs, int length) {
        return StringUtils.fill(cs, length, true);
    }

    public static final String fill(CharSequence cs, int length, boolean isCutout) {
        if (length < 0) {
            return EMPTY;
        }
        int actLength = (int)Math.ceil((double)length / (double)cs.length());
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < actLength; ++i) {
            sb.append(cs);
        }
        return isCutout ? StringUtils.substring(sb.toString(), length) : sb.toString();
    }

    public static final String fill(String source, char c, int len) {
        return StringUtils.fill(source, c, len, 2);
    }

    public static final String fill(String source, char c, int len, int align) {
        return StringUtils.fill(source, Character.toString(c), len, align);
    }

    public static final String fill(String source, int len) {
        return StringUtils.fill(source, len, 2);
    }

    public static final String fill(String source, int len, int align) {
        return StringUtils.fill(source, CHAR_SPACE, len, align);
    }

    public static final String fill(String source, String str, int length, int align) {
        if (source == null || str == null) {
            return source;
        }
        if (source.length() > length) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        String fillStr = StringUtils.fill((CharSequence)str, length - source.getBytes().length);
        switch (align) {
            case 0: {
                buffer.append(fillStr).append(source);
                break;
            }
            case 1: {
                int centerIdx = source.length() / 2;
                buffer.append(StringUtils.substring(source, centerIdx)).append(fillStr).append(StringUtils.substring(source, centerIdx, source.length() - centerIdx));
                break;
            }
            case 2: {
                buffer.append(source).append(fillStr);
                break;
            }
            default: {
                buffer.append(source);
            }
        }
        return buffer.toString();
    }

    public static final boolean contains(String[] strArray, String str, boolean ignoreCase) {
        if (Objects.nonNull(strArray) && strArray.length > 0) {
            return Arrays.stream(strArray).anyMatch(s -> StringUtils.equals(s, str, ignoreCase));
        }
        return Objects.isNull(str);
    }

    public static final boolean contains(Collection<String> collections, String str) {
        return collections.contains(str);
    }

    public static final boolean contains(Collection<String> collections, String str, boolean ignoreCase) {
        if (Objects.isNull(collections)) {
            return false;
        }
        if (ignoreCase) {
            String[] strArray = collections.toArray(new String[collections.size()]);
            return StringUtils.contains(strArray, str, true);
        }
        return collections.contains(str);
    }

    public static final boolean isDoubleByte(char c) {
        return c >>> 8 != 0;
    }

    public static final boolean isChinese(String str) {
        Pattern pattern = Pattern.compile("[\u0391-\uffe5]+$");
        return pattern.matcher(str).matches();
    }

    public static final String toFixLength(String str, int length) {
        if (str == null || length <= 0) {
            return EMPTY;
        }
        if (str.getBytes().length <= length) {
            return str;
        }
        StringBuffer buff = new StringBuffer();
        int index = 0;
        length -= 3;
        while (length > 0) {
            char c = str.charAt(index);
            length -= c < '\u0080' ? 1 : 2;
            buff.append(c);
            ++index;
        }
        buff.append("...");
        return buff.toString();
    }

    public static final boolean isLetter(String str) {
        if (str == null || str.length() < 0) {
            return false;
        }
        return LETTER_PATTERN.matcher(str).matches();
    }

    public static final boolean isEmail(String email) {
        if (email == null || email.length() < 1 || email.length() > 256) {
            return false;
        }
        return EMAIL_PATTER.matcher(email).matches();
    }

    public static final String byte2String(byte[] data) {
        return StringUtils.byte2String(data, false);
    }

    public static final String byte2String(byte[] data, boolean lowerCase) {
        if (data == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String tmpStr = Integer.toHexString(data[i] & 0xFF);
            tmpStr = StringUtils.leftPad(tmpStr, 2, '0');
            buffer.append(tmpStr);
        }
        return lowerCase ? buffer.toString() : StringUtils.upperCase(buffer.toString());
    }

    public static final byte[] string2Byte(String strData) throws NumberFormatException {
        byte[] srcData = strData.getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int dataLength = srcData.length;
        for (int i = 0; i < dataLength; ++i) {
            if (srcData[i] == 48 && dataLength >= i + 4 && (srcData[i + 1] == 120 || srcData[i + 1] == 88)) {
                baos.write((byte)Integer.parseInt(new String(srcData, i + 2, 2), 16));
                i += 3;
                continue;
            }
            if (srcData[i] == 92) {
                if (i + 1 < dataLength) {
                    switch (srcData[i + 1]) {
                        case 114: {
                            baos.write(13);
                            break;
                        }
                        case 116: {
                            baos.write(9);
                            break;
                        }
                        case 110: {
                            baos.write(10);
                            break;
                        }
                        case 98: {
                            baos.write(8);
                            break;
                        }
                        case 102: {
                            baos.write(12);
                            break;
                        }
                        case 39: {
                            baos.write(39);
                            break;
                        }
                        case 34: {
                            baos.write(34);
                            break;
                        }
                        case 92: {
                            baos.write(92);
                            break;
                        }
                        case 48: {
                            baos.write(0);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal string: [" + strData + "]");
                        }
                    }
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("Illegal string: [" + strData + "]");
            }
            baos.write(srcData[i]);
        }
        return baos.toByteArray();
    }

    public static final String getBlankStr(char c, int length) {
        return StringUtils.getBlankStr(Character.toString(c), length);
    }

    public static final String getBlankStr(int length) {
        return StringUtils.getBlankStr(CHAR_SPACE, length);
    }

    public static final String getBlankStr(String str, int length) {
        return StringUtils.getBlankStr(str, length, false);
    }

    public static final String getBlankStr(String str, int length, boolean isCutout) {
        if (StringUtils.isEmpty(str)) {
            str = CHAR_SPACE;
        }
        return StringUtils.fill((CharSequence)str, length, isCutout);
    }

    public static final String toString(Object obj) {
        return Objects.isNull(obj) ? null : (obj.getClass().isArray() ? (obj instanceof byte[] ? new String((byte[])obj) : Arrays.toString((Object[])obj)) : obj.toString());
    }

    public static String uuid(boolean upperCase) {
        String uuid = UUID.randomUUID().toString().replace("-", EMPTY);
        return upperCase ? uuid.toUpperCase() : uuid.toLowerCase();
    }

    public static final String getUUID() {
        return StringUtils.uuid(true);
    }

    public static final String replaceNRT(String str) {
        return StringUtils.nonEmpty(str) ? NRT_PATTERN.matcher(str.replaceAll("  ", EMPTY)).replaceAll(EMPTY) : null;
    }

    public static String underLine(String str) {
        return StringUtils.delimiter(str, "_");
    }

    public static String delimiter(String str, String delimiter) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isUpperCase(str.charAt(i))) {
                builder.append(delimiter);
            }
            builder.append(Character.valueOf(str.charAt(i)));
        }
        String rtnStr = StringUtils.lowerCase(builder.toString());
        return rtnStr.startsWith(delimiter) ? rtnStr.substring(1) : rtnStr;
    }

    public static String camelCase(CharSequence name) {
        if (null == name) {
            return null;
        }
        String underLine = "_";
        String name2 = name.toString();
        if (name2.contains(underLine)) {
            StringBuilder sb = new StringBuilder(name2.length());
            boolean upperCase = false;
            for (int i = 0; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c));
            }
            return sb.toString();
        }
        return StringUtils.lowerCase((String)name);
    }

    public static final String encode(String str, String srcCharset, String targetCharset) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        try {
            return new String(str.getBytes(srcCharset), targetCharset);
        }
        catch (Exception exception) {
            return str;
        }
    }

    public static final Map<String, String> map(String mapStr) {
        String[] entrys;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : entrys = StringUtils.split(mapStr, EN_COMMA)) {
            String[] strs = StringUtils.split(StringUtils.trim(entry), "=");
            if (strs.length <= 1) continue;
            map.put(strs[0].trim(), strs[1].trim());
        }
        return map;
    }

    public static final byte[] escape(byte[] str) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        block10: for (int i = 0; i < str.length; ++i) {
            switch (str[i]) {
                case 10: {
                    bout.write(92);
                    bout.write(110);
                    continue block10;
                }
                case 9: {
                    bout.write(92);
                    bout.write(116);
                    continue block10;
                }
                case 13: {
                    bout.write(92);
                    bout.write(114);
                    continue block10;
                }
                case 12: {
                    bout.write(92);
                    bout.write(102);
                    continue block10;
                }
                case 0: {
                    bout.write(92);
                    bout.write(48);
                    continue block10;
                }
                case 34: {
                    bout.write(92);
                    bout.write(34);
                    continue block10;
                }
                case 8: {
                    bout.write(92);
                    bout.write(98);
                    continue block10;
                }
                case 92: {
                    bout.write(92);
                    bout.write(92);
                    continue block10;
                }
                default: {
                    bout.write(str[i]);
                }
            }
        }
        return bout.toByteArray();
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static char toLowerAscii(char c) {
        if (StringUtils.isUpperCase(c)) {
            c = (char)(c + 32);
        }
        return c;
    }

    public static final String trim(String str) {
        return StringUtils.isEmpty(str) ? str : str.trim();
    }

    public static String repeat(CharSequence cs, int count) {
        if (null == cs) {
            return null;
        }
        return StringUtils.repeat(cs.toString(), count);
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String repeat(String str, String separator, int repeat) {
        if (str == null || separator == null) {
            return StringUtils.repeat(str, repeat);
        }
        String result = StringUtils.repeat(str + separator, repeat);
        return StringUtils.removeEnd(result, separator);
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return EMPTY;
        }
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String rightPad(String str, int size) {
        return StringUtils.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtils.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = CHAR_SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String leftPad(String str, int size) {
        return StringUtils.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtils.repeat(padChar, pads).concat(str);
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String remove(String str, char remove) {
        if (StringUtils.isEmpty(str) || str.indexOf(remove) == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static String removeAll(String text, String regex) {
        return StringUtils.replaceAll(text, regex, EMPTY);
    }

    public static String removeFirst(String text, String regex) {
        return StringUtils.replaceFirst(text, regex, EMPTY);
    }

    public static String replaceFirst(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceFirst(regex, replacement);
    }

    public static String replaceAll(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String removeAll(CharSequence str, CharSequence strToRemove) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.convert(str);
        }
        return str.toString().replace(strToRemove, EMPTY);
    }

    public static String removeAny(CharSequence str, CharSequence ... strsToRemove) {
        String result = StringUtils.convert(str);
        if (StringUtils.nonEmpty(str)) {
            for (CharSequence strToRemove : strsToRemove) {
                result = StringUtils.removeAll((CharSequence)result, strToRemove);
            }
        }
        return result;
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (null == str || ArrayUtils.isEmpty(chars)) {
            return StringUtils.convert(str);
        }
        int len = str.length();
        if (0 == len) {
            return StringUtils.convert(str);
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (ArrayUtils.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = CHAR_SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    private static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return string.getBytes(charset);
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytes(string, StandardCharsets.UTF_8);
    }

    public static String newStringUtf8(byte[] bytes) {
        return StringUtils.newString(bytes, StandardCharsets.UTF_8);
    }

    private static String newString(byte[] bytes, Charset charset) {
        return bytes == null ? null : new String(bytes, charset);
    }

    public static String initialLetterLowercase(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        StringBuilder builder = new StringBuilder(string);
        char initialLetter = Character.toLowerCase(builder.charAt(0));
        builder.setCharAt(0, initialLetter);
        return builder.toString();
    }

    public static String remove(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return StringUtils.replace(str, remove, EMPTY, -1);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        return StringUtils.replace(text, searchString, replacement, max, false);
    }

    private static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        int start;
        int end;
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        String searchText = text;
        if (ignoreCase) {
            searchText = text.toLowerCase();
            searchString = searchString.toLowerCase();
        }
        if ((end = searchText.indexOf(searchString, start = 0)) == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = searchText.indexOf(searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return EMPTY;
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return StringUtils.bytes(str, StandardCharsets.UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return StringUtils.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return StringUtils.bytes(str, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static boolean startsWith(String str, String startWith) {
        return StringUtils.nonEmpty(str) && StringUtils.nonEmpty(startWith) && str.startsWith(startWith);
    }

    public static boolean startsWithAny(String sequence, String ... searchStrings) {
        if (StringUtils.isEmpty(sequence) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        return ArrayUtils.parallelStream(searchStrings).anyMatch(sequence::startsWith);
    }

    public static boolean endsWithAny(String sequence, String ... searchStrings) {
        if (StringUtils.isEmpty(sequence) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        return ArrayUtils.parallelStream(searchStrings).anyMatch(sequence::endsWith);
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtils.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtils.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str != null && searchStr != null) {
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            fromIndex = Math.min(fromIndex, str.length());
            if (searchStr.length() == 0) {
                return fromIndex;
            }
            if (!ignoreCase) {
                if (fromIndex > str.length() || fromIndex + searchStr.length() > str.length()) {
                    return -1;
                }
                return str.toString().lastIndexOf(searchStr.toString(), str.length());
            }
            for (int i = str.length(); i > fromIndex; --i) {
                if (!StringUtils.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        return null != str1 && null != str2 && str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static int length(String str) {
        return StringUtils.nonEmpty(str) ? str.length() : 0;
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String str(Object obj, String charsetName) {
        return StringUtils.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringUtils.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringUtils.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringUtils.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtils.isArray(obj)) {
            return ArrayUtils.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StringUtils.str(bytes, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StringUtils.str(bytes, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringUtils.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StringUtils.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }
}

