/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.Asserts;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public final class ReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
        throw new IllegalStateException("Not Instantiate!");
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return org.springframework.util.ReflectionUtils.findMethod(clazz, (String)name);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        return org.springframework.util.ReflectionUtils.findMethod(clazz, (String)name, (Class[])paramTypes);
    }

    public static void setPropertyValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        if (Objects.nonNull(field)) {
            ReflectionUtils.setPropertyValue(object, field, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertyValue(Object object, Field field, Object value) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
    }

    public static <T> T getPropertyValue(Object object, String fieldName) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        return Objects.nonNull(field) ? (T)ReflectionUtils.getPropertyValue(object, field) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getPropertyValue(Object object, Field field) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            Object object2 = field.get(object);
            return (T)object2;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
        return null;
    }

    public static Object getPropertyValue(Object object, String clazzName, String fieldName) {
        try {
            Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)ClassUtils.getDefaultClassLoader());
            if (ClassUtils.isAssignableValue((Class)clazz, (Object)object)) {
                return ReflectionUtils.getPropertyValue(object, fieldName);
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        try {
            return Objects.nonNull(object) ? ReflectionUtils.getDeclaredField(object.getClass(), fieldName) : null;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Field getDeclaredField(Class<?> classType, String fieldName) throws Exception {
        while (Objects.nonNull(classType) && !Object.class.equals(classType)) {
            Field field = classType.getDeclaredField(fieldName);
            if (Objects.nonNull(field) && !field.isSynthetic()) {
                return field;
            }
            classType = classType.getSuperclass();
        }
        return null;
    }

    public static List<Field> getFields(Class<?> classType, Class<?> stopClass) {
        Asserts.nonNull(classType, "The class must not be null");
        if (stopClass != null) {
            boolean isSuper = false;
            for (Class<?> superclass = classType.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                if (superclass != stopClass) continue;
                isSuper = true;
                break;
            }
            if (!isSuper) {
                throw new IllegalArgumentException(" InCorrect Super Class");
            }
        }
        LinkedList<Field> fields = new LinkedList<Field>();
        Collections.addAll(fields, ReflectionUtils.getAvailableFields(classType.getDeclaredFields()));
        for (Class<?> superClass = classType.getSuperclass(); superClass != stopClass; superClass = superClass.getSuperclass()) {
            fields.addAll(ReflectionUtils.getFields(superClass));
        }
        return fields;
    }

    public static Field[] getAvailableFields(Field ... fields) {
        List fieldList = Optional.ofNullable(fields).map(fs -> Arrays.stream(fs).filter(f -> !f.isSynthetic() && ReflectionUtils.isAvailableField(f)).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        return fieldList.toArray(new Field[0]);
    }

    private static boolean isAvailableField(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isNative(modifiers);
    }

    public static List<Field> getFields(Class<?> classType) {
        return ReflectionUtils.getFields(classType, null);
    }

    public static List<Field> getFields(Class<?> classType, boolean excludeStatic, boolean excludeFinal) {
        List<Field> fields = ReflectionUtils.getFields(classType, null);
        if (excludeStatic || excludeFinal) {
            fields.removeIf(field -> excludeStatic && Modifier.isStatic(field.getModifiers()));
            fields.removeIf(field -> excludeFinal && Modifier.isFinal(field.getModifiers()));
        }
        return fields;
    }

    public static Object getMethodValue(Object object, String methodName) {
        Method method = ReflectionUtils.findMethod(object.getClass(), methodName);
        return Objects.nonNull(method) ? ReflectionUtils.invokeMethod(method, object) : null;
    }

    public static Object invokeMethod(Method method, Object target) {
        return org.springframework.util.ReflectionUtils.invokeMethod((Method)method, (Object)target);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        return org.springframework.util.ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])args);
    }

    public static boolean isAssignableValue(Class<?> classType, Object target) {
        return ClassUtils.isAssignableValue(classType, (Object)target);
    }

    public static boolean isAssignableValue(Class<?>[] classTypes, Object target) {
        return Arrays.stream(classTypes).anyMatch(classType -> ReflectionUtils.isAssignableValue(classType, target));
    }

    public static boolean isAssignableValue(Collection<Class<?>> classTypes, Object target) {
        return classTypes.stream().anyMatch(classType -> ReflectionUtils.isAssignableValue(classType, target));
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        return ClassUtils.isAssignable(lhsType, rhsType);
    }

    public static boolean isAssignable(Class<?>[] lhsTypes, Class<?> rhsType) {
        return Arrays.stream(lhsTypes).anyMatch(classType -> ReflectionUtils.isAssignable(classType, rhsType));
    }

    public static boolean isAssignable(Collection<Class<?>> lhsTypes, Class<?> rhsType) {
        return lhsTypes.stream().anyMatch(classType -> ReflectionUtils.isAssignable(classType, rhsType));
    }

    public static Class<?> forName(String className, ClassLoader classLoader) {
        try {
            return ClassUtils.forName((String)className, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            logger.error(String.format("Class[%s] not found!", className), (Throwable)e);
            return null;
        }
    }

    public static Class<?> forName(String className) {
        return ReflectionUtils.forName(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        return ClassUtils.isPresent((String)className, (ClassLoader)classLoader);
    }

    public static boolean isPresent(String className) {
        return ReflectionUtils.isPresent(className, null);
    }

    public static List<Class<?>> loadClass(String ... className) {
        return Objects.nonNull(className) && className.length > 0 ? Arrays.stream(className).filter(ReflectionUtils::isPresent).map(ReflectionUtils::forName).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
    }
}

