/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;

public class NumberUtils {
    public static final String[] RMB_NUMBERS = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u4e24", "\u5eff", "\u5345", "\u3007"};
    public static final String[] BIG_NUMBERS = new String[]{"\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396", "\u4fe9", "\u5eff", "\u5345", "\u96f6"};
    public static final Long[] TO_NUMBERS = new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 2L, 2L, 3L, 0L};
    public static final String[] RMB_MULT = new String[]{"\u4ebf", "\u4e07", "\u5343", "\u767e", "\u5341"};
    public static final String[] BIG_RMB_MULT = new String[]{"\u5104", "\u842c", "\u4edf", "\u4f70", "\u62fe"};
    public static final Long[] TO_MULT = new Long[]{100000000L, 10000L, 1000L, 100L, 10L};
    public static final String[] RMB_DW = new String[]{"\u5143", "\u5706"};
    public static final String[] DECIMAL_DW = new String[]{"\u89d2", "\u5206"};
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DEFAULT_DIV_SCALE = 10;
    private static final Pattern HEX_PATTERN = Pattern.compile("[^0-9a-fA-F]+");
    private static char[] chineseAmt = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static char[] units = new char[]{'\u62fe', '\u4f70', '\u4edf'};
    private static char[] chineseUnits = new char[]{'\u5143', '\u4e07', '\u4ebf', '\u5146'};
    private static char[] smallUnits = new char[]{'\u5206', '\u89d2'};
    private static BigInteger radix = new BigInteger("10");
    private static char ZEROCHAR = (char)38646;

    private NumberUtils() {
    }

    public static BigDecimal nullDefaultZero(Number number) {
        if (Objects.nonNull(number)) {
            return new BigDecimal(number.toString());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal nullDefaultZero(String string) {
        if (StringUtils.nonEmpty(string)) {
            return new BigDecimal(string);
        }
        return BigDecimal.ZERO;
    }

    public static <T> BigDecimal nullDefaultZero(T t) {
        if (Objects.nonNull(t)) {
            return new BigDecimal(t.toString());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal toBigDecimal(String string, String defaultValue) {
        if (StringUtils.nonEmpty(string)) {
            return new BigDecimal(string);
        }
        return NumberUtils.toBigDecimal(defaultValue);
    }

    public static BigDecimal toBigDecimal(String string, Number defaultValue) {
        if (StringUtils.nonEmpty(string)) {
            return new BigDecimal(string);
        }
        return NumberUtils.toBigDecimal(defaultValue);
    }

    public double sub(float f1, float f2) {
        return NumberUtils.sub0(Float.toString(f1), Float.toString(f2)).doubleValue();
    }

    public double sub(double d1, float f2) {
        return NumberUtils.sub0(Double.toString(d1), Float.toString(f2)).doubleValue();
    }

    public double sub(float f1, double d2) {
        return NumberUtils.sub0(Float.toString(f1), Double.toString(d2)).doubleValue();
    }

    public double sub(double d1, double d2) {
        return NumberUtils.sub0(Double.toString(d1), Double.toString(d2)).doubleValue();
    }

    public static <T> BigDecimal sub0(T ... arrays) {
        if (ArrayUtils.isEmpty(arrays)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = NumberUtils.nullDefaultZero(arrays[0]);
        return result.subtract(ArrayUtils.parallelStream(arrays, 1, arrays.length).map(NumberUtils::toBigDecimal).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    public static BigDecimal sub(Number ... arrays) {
        return NumberUtils.sub0(arrays);
    }

    public static BigDecimal sub(BigDecimal ... bigDecimals) {
        if (ArrayUtils.isEmpty(bigDecimals)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = bigDecimals[0] != null ? bigDecimals[0] : BigDecimal.ZERO;
        return result.subtract(ArrayUtils.parallelStream(bigDecimals, 1, bigDecimals.length).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    public static double multiply(float f1, float f2) {
        return NumberUtils.multiply0(Float.toString(f1), Float.toString(f2)).doubleValue();
    }

    public static double multiply(float f1, double d2) {
        return NumberUtils.multiply0(Float.toString(f1), Double.toString(d2)).doubleValue();
    }

    public static double multiply(double d1, double d2) {
        return NumberUtils.multiply0(Double.toString(d1), Double.toString(d2)).doubleValue();
    }

    public static BigDecimal multiply(Number ... numbers) {
        return NumberUtils.multiply0(numbers);
    }

    @SafeVarargs
    public static <T> BigDecimal multiply0(T ... array) {
        if (ArrayUtils.isEmpty(array)) {
            return BigDecimal.ZERO;
        }
        return ArrayUtils.parallelStream(array).map(NumberUtils::toBigDecimal).filter(Objects::nonNull).reduce(BigDecimal::multiply).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal multiply(BigDecimal ... bigDecimals) {
        if (ArrayUtils.isEmpty(bigDecimals)) {
            return BigDecimal.ZERO;
        }
        return ArrayUtils.parallelStream(bigDecimals).filter(Objects::nonNull).reduce(BigDecimal::multiply).orElse(BigDecimal.ZERO);
    }

    public static double divide(float f1, float f2) {
        return NumberUtils.divide(f1, f2, 10);
    }

    public static double divide(float f1, float f2, int scale) {
        return NumberUtils.divide(f1, f2, scale, RoundingMode.HALF_UP);
    }

    public static double divide(float f1, float f2, RoundingMode roundingMode) {
        return NumberUtils.divide(f1, f2, 10, roundingMode);
    }

    public static double divide(float f1, float f2, int scale, RoundingMode roundingMode) {
        return NumberUtils.divide(Float.toString(f1), Float.toString(f2), scale, roundingMode).doubleValue();
    }

    public static double divide(double d1, double d2) {
        return NumberUtils.divide(d1, d2, 10);
    }

    public static double divide(double d1, double d2, int scale) {
        return NumberUtils.divide(d1, d2, scale, RoundingMode.HALF_UP);
    }

    public static double divide(double d1, double d2, RoundingMode roundingMode) {
        return NumberUtils.divide(d1, d2, 10, roundingMode);
    }

    public static double divide(double d1, double d2, int scale, RoundingMode roundingMode) {
        return NumberUtils.divide(Double.toString(d1), Double.toString(d2), scale, roundingMode).doubleValue();
    }

    public static BigDecimal divide(String s1, String n2) {
        return NumberUtils.divide(s1, n2, 10);
    }

    public static BigDecimal divide(String s1, String s2, int scale) {
        return NumberUtils.divide(s1, s2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(String s1, String s2, RoundingMode roundingMode) {
        return NumberUtils.divide(s1, s2, 10, roundingMode);
    }

    public static BigDecimal divide(String s1, String s2, int scale, RoundingMode roundingMode) {
        return NumberUtils.divide(NumberUtils.toBigDecimal(s1), NumberUtils.toBigDecimal(s2), scale, roundingMode);
    }

    public static BigDecimal divide(Number n1, Number n2) {
        return NumberUtils.divide(n1, n2, 10);
    }

    public static BigDecimal divide(Number n1, Number n2, int scale) {
        return NumberUtils.divide(n1, n2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(Number n1, Number n2, RoundingMode roundingMode) {
        return NumberUtils.divide(n1, n2, 10, roundingMode);
    }

    public static BigDecimal divide(Number n1, Number n2, int scale, RoundingMode roundingMode) {
        return NumberUtils.divide(NumberUtils.toBigDecimal(n1), NumberUtils.toBigDecimal(n2), scale, roundingMode);
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2) {
        return NumberUtils.divide(b1, b2, 10);
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2, int scale) {
        return NumberUtils.divide(b1, b2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2, RoundingMode roundingMode) {
        return NumberUtils.divide(b1, b2, 10, roundingMode);
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2, int scale, RoundingMode roundingMode) {
        Asserts.nonNull(b2, "Divider must be not null !");
        if (Objects.isNull(b1) || BigDecimal.ZERO.compareTo(b2) == 0) {
            return BigDecimal.ZERO;
        }
        return b1.divide(b2, Math.abs(scale), roundingMode);
    }

    public static int saturatedCastInt(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return value < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value;
    }

    public static String toStringRound(String string, int scale, RoundingMode roundingMode) {
        return NumberUtils.toStringRound(NumberUtils.toBigDecimal(string), scale, roundingMode);
    }

    public static String toStringRound(BigDecimal bigDecimal, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(bigDecimal, scale, roundingMode).toString();
    }

    public static BigDecimal round(Number number) {
        return NumberUtils.round(number, 10);
    }

    public static BigDecimal round(Number number, int scale) {
        return NumberUtils.round(number, scale, null);
    }

    public static BigDecimal round(Number number, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(NumberUtils.toBigDecimal(number), scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal bigDecimal) {
        return NumberUtils.round(bigDecimal, 10);
    }

    public static BigDecimal round(BigDecimal bigDecimal, int scale) {
        return NumberUtils.round(bigDecimal, scale, null);
    }

    public static BigDecimal round(String string) {
        return NumberUtils.round(string, 10);
    }

    public static BigDecimal round(String string, int scale) {
        return NumberUtils.round(NumberUtils.toBigDecimal(string), scale, null);
    }

    public static BigDecimal round(String string, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(NumberUtils.toBigDecimal(string), scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal bigDecimal, int scale, RoundingMode roundingMode) {
        if (Objects.isNull(bigDecimal)) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        roundingMode = Optional.ofNullable(roundingMode).orElse(RoundingMode.HALF_UP);
        return bigDecimal.setScale(scale, roundingMode);
    }

    public static String format(String pattern, Number value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String formatMoney(Number value) {
        return NumberUtils.format(",##0.00", value);
    }

    public static String formatPercent(double value, int scale) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(value);
    }

    public static boolean isNumber(CharSequence cs) {
        int i;
        int start;
        if (StringUtils.isBlank(cs)) {
            return false;
        }
        char[] chars = cs.toString().toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && (chars[start + 1] == 'x' || chars[start + 1] == 'X')) {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static <T> boolean isInteger(T value) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return false;
            }
            Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static <T> boolean isLong(T value) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return false;
            }
            Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static <T> boolean isDouble(T value) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return false;
            }
            Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static <T> boolean isFloat(T value) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return false;
            }
            Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static <T> boolean isBigDecimal(T value) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return false;
            }
            new BigDecimal(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static <T> Integer toInteger(T value) {
        return NumberUtils.toInteger(value, null);
    }

    public static <T> Integer toInteger(T value, Integer defVal) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return defVal;
            }
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public static <T> Long toLong(T value) {
        return NumberUtils.toLong(value, null);
    }

    public static <T> Long toLong(T value, Long defVal) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return defVal;
            }
            return Long.parseLong(val);
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public static <T> Double toDouble(T value) {
        return NumberUtils.toDouble(value, null);
    }

    public static <T> Double toDouble(T value, Double defVal) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return defVal;
            }
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public static <T> Float toFloat(T value) {
        return NumberUtils.toFloat(value, null);
    }

    public static <T> Float toFloat(T value, Float defVal) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return defVal;
            }
            return Float.valueOf(Float.parseFloat(val));
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public static <T> BigDecimal toBigDecimal(T value, BigDecimal defVal) {
        try {
            String val = StringUtils.replaceObjNull(value);
            if (Objects.isNull(val)) {
                return defVal;
            }
            return new BigDecimal(val);
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public static <T> BigDecimal toBigDecimal(T t) {
        if (Objects.nonNull(t)) {
            return new BigDecimal(t.toString());
        }
        return null;
    }

    public static BigDecimal toBigDecimal(Number number, Number defaultValue) {
        if (Objects.nonNull(number)) {
            return new BigDecimal(number.toString());
        }
        return NumberUtils.toBigDecimal(defaultValue);
    }

    public static double setScale(double value, int scale) {
        return NumberUtils.setScale(value, scale, RoundingMode.HALF_UP);
    }

    public static double setScale(double value, int scale, RoundingMode roundingMode) {
        return BigDecimal.valueOf(value).setScale(scale, roundingMode).doubleValue();
    }

    public static boolean isPrimes(int n) {
        Asserts.isTrue(n > 1, "The number must be > 1");
        int i = 2;
        while ((double)i <= Math.sqrt(n)) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int[] randomNumber(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new IllegalArgumentException("Size is larger than range between begin and end!");
        }
        int[] seed = new int[end - begin];
        for (int i = begin; i < end; ++i) {
            seed[i - begin] = i;
        }
        int[] ranArr = new int[size];
        ThreadLocalRandom ran = ThreadLocalRandom.current();
        for (int i = 0; i < size; ++i) {
            int j = ran.nextInt(seed.length - i);
            ranArr[i] = seed[j];
            seed[j] = seed[seed.length - 1 - i];
        }
        return ranArr;
    }

    public static Integer[] randomBySet(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new IllegalArgumentException("Size is larger than range between begin and end!");
        }
        ThreadLocalRandom ran = ThreadLocalRandom.current();
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < size) {
            set.add(begin + ran.nextInt(end - begin));
        }
        return set.toArray(new Integer[size]);
    }

    public static BigDecimal factorial(long start, long end) {
        if (start < end) {
            return BigDecimal.ZERO;
        }
        if (0L == start) {
            return new BigDecimal("1");
        }
        if (start == end) {
            return new BigDecimal(end);
        }
        return new BigDecimal(start).multiply(NumberUtils.factorial(start - 1L, end));
    }

    public static BigDecimal factorial(long start) {
        return NumberUtils.factorial(start, 1L);
    }

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = 0xFF & bytes[0];
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] byteConvert32Bytes(BigInteger bigInteger) {
        byte[] tmpd = null;
        if (Objects.isNull(bigInteger)) {
            return null;
        }
        if (bigInteger.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(bigInteger.toByteArray(), 1, tmpd, 0, 32);
        } else if (bigInteger.toByteArray().length == 32) {
            tmpd = bigInteger.toByteArray();
        } else {
            tmpd = new byte[32];
            for (int i = 0; i < 32 - bigInteger.toByteArray().length; ++i) {
                tmpd[i] = 0;
            }
            System.arraycopy(bigInteger.toByteArray(), 0, tmpd, 32 - bigInteger.toByteArray().length, bigInteger.toByteArray().length);
        }
        return tmpd;
    }

    public static BigInteger byteConvertInteger(byte[] bytes) {
        if (bytes[0] < 0) {
            byte[] temp = new byte[bytes.length + 1];
            temp[0] = 0;
            System.arraycopy(bytes, 0, temp, 1, bytes.length);
            return new BigInteger(temp);
        }
        return new BigInteger(bytes);
    }

    public static String getHexString(byte[] bytes) {
        return NumberUtils.getHexString(bytes, true);
    }

    public static String getHexString(byte[] bytes, boolean upperCase) {
        StringBuilder ret = new StringBuilder();
        for (byte aByte : bytes) {
            ret.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return upperCase ? ret.toString().toUpperCase() : ret.toString();
    }

    public static byte[] hexToByte(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = (byte)byteint;
            ++i;
            ++j;
        }
        return b;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static char[] encodeHex(byte[] bytes) {
        return NumberUtils.encodeHex(bytes, true);
    }

    public static char[] encodeHex(byte[] bytes, boolean toLowerCase) {
        return NumberUtils.encodeHex(bytes, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static char[] encodeHex(byte[] bytes, char[] toDigits) {
        int l = bytes.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & bytes[i]) >>> 4];
            out[j++] = toDigits[0xF & bytes[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] bytes) {
        return NumberUtils.encodeHexString(bytes, true);
    }

    public static String encodeHexString(byte[] bytes, boolean toLowerCase) {
        return NumberUtils.encodeHexString(bytes, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexString(byte[] bytes, char[] toDigits) {
        return new String(NumberUtils.encodeHex(bytes, toDigits));
    }

    public static byte[] decodeHex(char[] chars) {
        int len = chars.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = NumberUtils.toDigit(chars[j], j) << 4;
            f |= NumberUtils.toDigit(chars[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char c, int index) {
        int digit = Character.digit(c, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + c + " at index " + index);
        }
        return digit;
    }

    public static String stringToAsciiString(String content) {
        if (!NumberUtils.isNumber(content)) {
            throw new IllegalArgumentException("the content is not a string numeber");
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            String b = Integer.toHexString(c);
            result.append(b);
        }
        return result.toString();
    }

    public static String hexStringToString(String hexString, int encodeType) {
        StringBuilder result = new StringBuilder();
        int max = hexString.length() / encodeType;
        for (int i = 0; i < max; ++i) {
            char c = (char)NumberUtils.hexStringToAlgorism(hexString.substring(i * encodeType, (i + 1) * encodeType));
            result.append(c);
        }
        return result.toString();
    }

    public static int hexStringToAlgorism(String hex) {
        hex = hex.toUpperCase();
        int max = hex.length();
        int result = 0;
        for (int i = max; i > 0; --i) {
            char c = hex.charAt(i - 1);
            int algorism = 0;
            algorism = c >= '0' && c <= '9' ? c - 48 : c - 55;
            result = (int)((double)result + Math.pow(16.0, max - i) * (double)algorism);
        }
        return result;
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        StringBuilder result = new StringBuilder();
        block18: for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            switch (c) {
                case '0': {
                    result.append("0000");
                    continue block18;
                }
                case '1': {
                    result.append("0001");
                    continue block18;
                }
                case '2': {
                    result.append("0010");
                    continue block18;
                }
                case '3': {
                    result.append("0011");
                    continue block18;
                }
                case '4': {
                    result.append("0100");
                    continue block18;
                }
                case '5': {
                    result.append("0101");
                    continue block18;
                }
                case '6': {
                    result.append("0110");
                    continue block18;
                }
                case '7': {
                    result.append("0111");
                    continue block18;
                }
                case '8': {
                    result.append("1000");
                    continue block18;
                }
                case '9': {
                    result.append("1001");
                    continue block18;
                }
                case 'A': {
                    result.append("1010");
                    continue block18;
                }
                case 'B': {
                    result.append("1011");
                    continue block18;
                }
                case 'C': {
                    result.append("1100");
                    continue block18;
                }
                case 'D': {
                    result.append("1101");
                    continue block18;
                }
                case 'E': {
                    result.append("1110");
                    continue block18;
                }
                case 'F': {
                    result.append("1111");
                    continue block18;
                }
            }
        }
        return result.toString();
    }

    public static String asciiStringToString(String content) {
        StringBuilder result = new StringBuilder();
        int length = content.length() / 2;
        for (int i = 0; i < length; ++i) {
            String c = content.substring(i * 2, i * 2 + 2);
            int a = NumberUtils.hexStringToAlgorism(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result.append(d);
        }
        return result.toString();
    }

    public static String decimalToHexString(int decimal, int maxLength) {
        String result = "";
        result = Integer.toHexString(decimal);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return NumberUtils.patchHexString(result.toUpperCase(), maxLength);
    }

    public static String byteToString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte aByte : bytes) {
            char temp = (char)aByte;
            result.append(temp);
        }
        return result.toString();
    }

    public static int binaryToDecimal(String binary) {
        int max = binary.length();
        int result = 0;
        for (int i = max; i > 0; --i) {
            char c = binary.charAt(i - 1);
            int algorism = c - 48;
            result = (int)((double)result + Math.pow(2.0, max - i) * (double)algorism);
        }
        return result;
    }

    public static String decimalToHexString(int decimal) {
        String result = "";
        result = Integer.toHexString(decimal);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String patchHexString(String str, int maxLength) {
        if (HEX_PATTERN.matcher(str).find()) {
            throw new IllegalArgumentException("illegal hex string.");
        }
        if (str.length() > maxLength) {
            return str.substring(str.length() - maxLength);
        }
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < maxLength - str.length(); ++i) {
            temp.insert(0, "0");
        }
        str = (temp + str).substring(0, maxLength);
        return str;
    }

    public static int parseToInt(String s, int defaultInt) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return defaultInt;
        }
    }

    public static int parseToInt(String s, int defaultInt, int radix) {
        try {
            return Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            return defaultInt;
        }
    }

    public static String rmbBig2Small(String money) {
        int index = money.indexOf(RMB_DW[0]) > 0 ? money.indexOf(RMB_DW[0]) : money.indexOf(RMB_DW[1]);
        boolean isDecim = false;
        if (index == -1) {
            int n = index = money.indexOf(DECIMAL_DW[0]) > 0 ? money.indexOf(DECIMAL_DW[0]) : money.indexOf(DECIMAL_DW[1]);
            if (index == -1) {
                index = money.length();
            } else {
                --index;
                isDecim = true;
            }
        }
        String intPart = money.substring(0, index);
        String decimalPart = "";
        if (index + 1 < money.length()) {
            if (isDecim) {
                --index;
            }
            decimalPart = money.substring(index + 1);
        }
        String dp = NumberUtils.decimalBigToSmall(decimalPart);
        String ret = NumberUtils.intBigToSmall(intPart);
        ret = ret + "." + dp;
        return ret;
    }

    private static String decimalBigToSmall(String money) {
        if (money.length() == 0) {
            return "00";
        }
        StringBuilder sb = new StringBuilder();
        int index = money.indexOf(DECIMAL_DW[0]);
        String tmp = null;
        if (index > 0) {
            tmp = money.substring(0, index);
            sb.append(NumberUtils.getNumByBig(tmp));
        } else {
            sb.append(0);
        }
        index = money.indexOf(DECIMAL_DW[1]);
        if (index > 0) {
            tmp = money.substring(index - 1, index);
            sb.append(NumberUtils.getNumByBig(tmp));
        } else {
            sb.append(0);
        }
        return sb.toString();
    }

    private static String intBigToSmall(String money) {
        Long number = 0L;
        for (int i = 0; i < RMB_MULT.length; ++i) {
            int index;
            int n = index = money.lastIndexOf(RMB_MULT[i]) == -1 ? money.lastIndexOf(BIG_RMB_MULT[i]) : money.lastIndexOf(RMB_MULT[i]);
            if (index < 0) continue;
            String storeMult = money.substring(0, index);
            money = money.substring(index + 1);
            number = storeMult.length() <= 0 && TO_MULT[i].intValue() == 10 ? Long.valueOf(number + TO_MULT[i]) : Long.valueOf(number + TO_MULT[i] * NumberUtils.getPrexNum(storeMult));
        }
        number = number + NumberUtils.getNumByBig(money);
        return number.toString();
    }

    private static Long getPrexNum(String storeMult) {
        Long result = 0L;
        for (int i = 0; i < RMB_MULT.length; ++i) {
            int index;
            int n = index = storeMult.lastIndexOf(RMB_MULT[i]) == -1 ? storeMult.lastIndexOf(BIG_RMB_MULT[i]) : storeMult.lastIndexOf(RMB_MULT[i]);
            if (index < 0) continue;
            String storeMult2 = storeMult.substring(0, index);
            storeMult = storeMult.substring(index + 1);
            result = storeMult2.length() <= 0 && TO_MULT[i].intValue() == 10 ? Long.valueOf(result + TO_MULT[i]) : Long.valueOf(result + NumberUtils.getNumByBig(storeMult2) * TO_MULT[i]);
        }
        if (storeMult != null && storeMult.length() > 0) {
            result = result + NumberUtils.getNumByBig(storeMult);
        }
        return result;
    }

    private static Long getNumByBig(String big) {
        for (int j = 0; j < RMB_NUMBERS.length; ++j) {
            big = big.replaceAll(RMB_NUMBERS[j], TO_NUMBERS[j].toString());
            big = big.replaceAll(BIG_NUMBERS[j], TO_NUMBERS[j].toString());
        }
        try {
            return Long.valueOf(big);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static String formatInt(BigInteger num) {
        if (num.equals(BigInteger.ZERO)) {
            return "\u96f6\u5143";
        }
        if (num.toString().length() > 16) {
            throw new RuntimeException("too max num:" + num);
        }
        StringBuffer result = new StringBuffer("");
        int i = 0;
        char preChar = '\u0000';
        while (num.compareTo(BigInteger.ZERO) > 0) {
            StringBuffer tmp = new StringBuffer();
            BigInteger rest = num.mod(radix);
            num = num.divide(radix);
            if (rest.equals(BigInteger.ZERO) && i % 4 != 0 && preChar != ZEROCHAR && NumberUtils.exists(chineseAmt, Character.valueOf(preChar))) {
                tmp.append(ZEROCHAR);
            } else if (!rest.equals(BigInteger.ZERO)) {
                tmp.append(chineseAmt[rest.intValue()]);
                if (i % 4 != 0) {
                    tmp.append(units[i % 4 - 1]);
                }
            }
            if (i % 4 == 0) {
                if (i / 4 > 0 && NumberUtils.exists(chineseUnits, Character.valueOf(result.charAt(0)))) {
                    result.delete(0, 1);
                }
                tmp.append(chineseUnits[i / 4]);
            }
            preChar = tmp.length() > 0 ? tmp.charAt(0) : (char)'\u0000';
            ++i;
            result.insert(0, tmp);
        }
        return result.toString();
    }

    private static String formatSmall(int small) {
        if (small > 100) {
            throw new RuntimeException("too small");
        }
        StringBuilder result = new StringBuilder("");
        char preChar = '\u0000';
        int i = 0;
        while (small > 0) {
            StringBuffer tmp = new StringBuffer();
            int rest = small % 10;
            small /= 10;
            if (rest == 0 && preChar != ZEROCHAR && NumberUtils.exists(chineseAmt, Character.valueOf(preChar))) {
                tmp.append(ZEROCHAR);
            } else if (rest != 0) {
                tmp.append(chineseAmt[rest]);
                tmp.append(smallUnits[i]);
            }
            preChar = tmp.length() > 0 ? tmp.charAt(0) : (char)'\u0000';
            ++i;
            result.insert(0, tmp);
        }
        return result.toString();
    }

    private static boolean exists(Object object, Object ... objects) {
        if (objects == null && object == null) {
            return true;
        }
        return Objects.nonNull(objects) && objects.length > 0 && Arrays.asList(objects).contains(object);
    }

    public static String rmbSmall2Big(double num) {
        DecimalFormat df = new DecimalFormat("#.00");
        String input = df.format(num);
        StringBuffer sb = new StringBuffer();
        int index = input.indexOf(46);
        if (index != -1) {
            if (index != 0) {
                sb.append(NumberUtils.formatInt(new BigInteger(input.substring(0, index))));
                if (sb.indexOf(RMB_DW[0]) == -1) {
                    sb.append(RMB_DW[0]);
                }
            }
            sb.append(NumberUtils.formatSmall(Integer.parseInt(input.substring(index + 1))));
        }
        return sb.toString();
    }

    public static String formatAmt(String str) {
        return NumberUtils.formatAmt(str, "###,##0.00");
    }

    public static String formatAmt(String str, String pattern) {
        if (StringUtils.nonEmpty(str)) {
            try {
                return new DecimalFormat(pattern).format(Double.valueOf(str));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String formatAmt(Number number) {
        return NumberUtils.formatAmt(number.toString());
    }

    public static String formatAmt(Number number, String pattern) {
        return NumberUtils.formatAmt(number.toString(), pattern);
    }

    public static boolean isOddNumber(int a) {
        return (a & 1) == 1;
    }

    public static boolean isEvenNumber(int a) {
        return (a & 1) == 0;
    }

    public static int getAverageValue(int x, int y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    public static boolean is2NSquare(int x) {
        return (x & x - 1) == 0 && x != 0;
    }

    public static String algorismToHexString(int algorism, int maxLength) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return NumberUtils.patchHexString(result.toUpperCase(), maxLength);
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }
}

