/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import java.awt.Color;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class HexUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean isHexNumber(String value) {
        int index;
        int n = index = value.startsWith("-") ? 1 : 0;
        if (value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index)) {
            try {
                Long.decode(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static char[] encodeHex(byte[] data) {
        return HexUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(String str, Charset charset) {
        return HexUtils.encodeHex(StringUtils.bytes((CharSequence)str, charset), true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtils.encodeHexStr(data, true);
    }

    public static String encodeHexStr(String data, Charset charset) {
        return HexUtils.encodeHexStr(StringUtils.bytes((CharSequence)data, charset), true);
    }

    public static String encodeHexStr(String data) {
        return HexUtils.encodeHexStr(data, StandardCharsets.UTF_8);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String decodeHexStr(String hexStr) {
        return HexUtils.decodeHexStr(hexStr, StandardCharsets.UTF_8);
    }

    public static String decodeHexStr(String hexStr, Charset charset) {
        if (StringUtils.isEmpty(hexStr)) {
            return hexStr;
        }
        return HexUtils.decodeHexStr(hexStr.toCharArray(), charset);
    }

    public static String decodeHexStr(char[] hexData, Charset charset) {
        return StringUtils.convert(HexUtils.decodeHex(hexData), charset);
    }

    public static byte[] decodeHex(char[] hexData) {
        int len = hexData.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtils.toDigit(hexData[j], j) << 4;
            f |= HexUtils.toDigit(hexData[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static byte[] decodeHex(String hexStr) {
        if (StringUtils.isEmpty(hexStr)) {
            return null;
        }
        hexStr = StringUtils.removeAll((CharSequence)hexStr, ' ');
        return HexUtils.decodeHex(hexStr.toCharArray());
    }

    public static String encodeColor(Color color) {
        return HexUtils.encodeColor(color, "#");
    }

    public static String encodeColor(Color color, String prefix) {
        StringBuilder builder = new StringBuilder(prefix);
        String colorHex = Integer.toHexString(color.getRed());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getGreen());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getBlue());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        return builder.toString();
    }

    public static Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    public static String toUnicodeHex(int value) {
        StringBuilder builder = new StringBuilder(6);
        builder.append("\\u");
        String hex = HexUtils.toHex(value);
        int len = hex.length();
        if (len < 4) {
            builder.append("0000", 0, 4 - len);
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toUnicodeHex(char ch) {
        return "\\u" + DIGITS_LOWER[ch >> 12 & 0xF] + DIGITS_LOWER[ch >> 8 & 0xF] + DIGITS_LOWER[ch >> 4 & 0xF] + DIGITS_LOWER[ch & 0xF];
    }

    public static String toHex(int value) {
        return Integer.toHexString(value);
    }

    public static String toHex(long value) {
        return Long.toHexString(value);
    }

    public static void appendHex(StringBuilder builder, byte b, boolean toLowerCase) {
        char[] toDigits = toLowerCase ? DIGITS_LOWER : DIGITS_UPPER;
        int high = (b & 0xF0) >>> 4;
        int low = b & 0xF;
        builder.append(toDigits[high]);
        builder.append(toDigits[low]);
    }

    public static BigInteger toBigInteger(String hexStr) {
        if (null == hexStr) {
            return null;
        }
        return new BigInteger(hexStr, 16);
    }

    private static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexUtils.encodeHex(data, toDigits));
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

