/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public final class Asserts {
    private static final String DEFAULT_NULL = "the element is non-null";
    private static final String DEFAULT_NON_NULL = "the element is null";
    private static final String DEFAULT_MIN_NUMBER = "the value is greater than min value";
    private static final String DEFAULT_MAX_NUMBER = "the value is smaller than max value";
    private static final String DEFAULT_TRUE = "the expression is false";
    private static final String DEFAULT_FALSE = "the expression is true";
    private static final String DEFAULT_EQUALS = "the two objects are not equal";
    private static final String DEFAULT_NON_EQUALS = "the two objects are equal";
    private static final String DEFAULT_EMPTY = "the string is not empty";
    private static final String DEFAULT_NOT_EMPTY = "the string is empty";
    private static final String DEFAULT_BLANK = "the char sequence  is not blank";
    private static final String DEFAULT_NOT_BLANK = "the char sequence is blank";
    private static final String DEFAULT_CONTAINS = "the object is not contains";
    private static final String DEFAULT_NOT_CONTAINS = "the object is contains";

    private Asserts() {
    }

    public static <T> Collection<T> nonEmpty(Collection<T> t, String ... errorMessage) {
        if (CollectionUtils.isEmpty(t)) {
            throw new NullPointerException(Asserts.formatErrorMessage(DEFAULT_NON_NULL, errorMessage));
        }
        return t;
    }

    public static <K, V> Map<K, V> nonEmpty(Map<K, V> m, String ... errorMessage) {
        if (CollectionUtils.isEmpty(m)) {
            throw new NullPointerException(Asserts.formatErrorMessage(DEFAULT_NON_NULL, errorMessage));
        }
        return m;
    }

    @Deprecated
    public static void notEmpty(CharSequence cs, String ... errorMessage) {
        Asserts.nonEmpty(cs, errorMessage);
    }

    public static void nonEmpty(CharSequence cs, String ... errorMessage) {
        if (StringUtils.isEmpty(cs)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NOT_EMPTY, errorMessage));
        }
    }

    public static <T> Collection<T> isEmpty(Collection<T> t, String ... errorMessage) {
        if (CollectionUtils.nonEmpty(t)) {
            throw new IllegalArgumentException(Asserts.formatErrorMessage(DEFAULT_NON_NULL, errorMessage));
        }
        return t;
    }

    public static <K, V> Map<K, V> isEmpty(Map<K, V> m, String ... errorMessage) {
        if (CollectionUtils.nonEmpty(m)) {
            throw new IllegalArgumentException(Asserts.formatErrorMessage(DEFAULT_NON_NULL, errorMessage));
        }
        return m;
    }

    public static void isEmpty(CharSequence cs, String ... errorMessage) {
        if (StringUtils.nonEmpty(cs)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_EMPTY, errorMessage));
        }
    }

    public static <T> T isNull(T t, String ... errorMessage) {
        if (Objects.nonNull(t)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NULL, errorMessage));
        }
        return null;
    }

    public static <T> T nonNull(T t, String ... errorMessage) {
        if (Objects.isNull(t)) {
            throw new NullPointerException(Asserts.formatErrorMessage(DEFAULT_NON_NULL, errorMessage));
        }
        return t;
    }

    public static void minNumber(Number value, Number minVal, String ... errorMessage) {
        if (value.doubleValue() > minVal.doubleValue()) {
            throw new IllegalArgumentException(Asserts.formatErrorMessage(DEFAULT_MIN_NUMBER, errorMessage));
        }
    }

    public static void maxNumber(Number value, Number maxVal, String ... errorMessage) {
        if (value.doubleValue() < maxVal.doubleValue()) {
            throw new IllegalArgumentException(Asserts.formatErrorMessage(DEFAULT_MAX_NUMBER, errorMessage));
        }
    }

    public static void isTrue(boolean expression, String ... errorMessage) {
        if (!expression) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_TRUE, errorMessage));
        }
    }

    public static void isFalse(boolean expression, String ... errorMessage) {
        if (expression) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_FALSE, errorMessage));
        }
    }

    public static void notEquals(Object obj1, Object obj2, String ... errorMessage) {
        if (Objects.equals(obj1, obj2)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NON_EQUALS, errorMessage));
        }
    }

    public static void isEquals(Object obj1, Object obj2, String ... errorMessage) {
        if (!Objects.equals(obj1, obj2)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_EQUALS, errorMessage));
        }
    }

    public static void isContains(String str, CharSequence cs, String ... errorMessage) {
        if (!str.contains(cs)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NOT_CONTAINS, errorMessage));
        }
    }

    public static <T> void isContains(Collection<T> collection, T object, String ... errorMessage) {
        if (!collection.contains(object)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NOT_CONTAINS, errorMessage));
        }
    }

    public static <T> void isContains(T[] array, T object, String ... errorMessage) {
        if (!ArrayUtils.contains(array, object)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NOT_CONTAINS, errorMessage));
        }
    }

    public static <K, V> void isContainsKey(Map<K, V> map, K key, String ... errorMessage) {
        if (!map.containsKey(key)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NOT_CONTAINS, errorMessage));
        }
    }

    public static <K, V> void isContainsValue(Map<K, V> map, V value, String ... errorMessage) {
        if (!map.containsValue(value)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NOT_CONTAINS, errorMessage));
        }
    }

    public static void nonContains(String str, CharSequence cs, String ... errorMessage) {
        if (str.contains(cs)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_CONTAINS, errorMessage));
        }
    }

    public static <T> void nonContains(Collection<T> collection, T object, String ... errorMessage) {
        if (collection.contains(object)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_CONTAINS, errorMessage));
        }
    }

    public static <T> void nonContains(T[] array, T object, String ... errorMessage) {
        if (ArrayUtils.contains(array, object)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_CONTAINS, errorMessage));
        }
    }

    public static <K, V> void nonContainsKey(Map<K, V> map, K key, String ... errorMessage) {
        if (map.containsKey(key)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_CONTAINS, errorMessage));
        }
    }

    public static <K, V> void nonContainsValue(Map<K, V> map, V value, String ... errorMessage) {
        if (map.containsValue(value)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_CONTAINS, errorMessage));
        }
    }

    @Deprecated
    public static void notBlank(CharSequence cs, String ... errorMessage) {
        Asserts.nonBlank(cs, errorMessage);
    }

    public static void nonBlank(CharSequence cs, String ... errorMessage) {
        if (StringUtils.isBlank(cs)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_BLANK, errorMessage));
        }
    }

    public static void isBlank(CharSequence cs, String ... errorMessage) {
        if (StringUtils.nonBlank(cs)) {
            throw new IllegalStateException(Asserts.formatErrorMessage(DEFAULT_NOT_BLANK, errorMessage));
        }
    }

    private static String formatErrorMessage(String defaultMessage, String[] errorMessage) {
        if (Objects.isNull(errorMessage) || errorMessage.length == 0) {
            return defaultMessage;
        }
        if (errorMessage.length == 1) {
            return errorMessage[0];
        }
        return String.format(errorMessage[0], ArrayUtils.sub(errorMessage, 1));
    }
}

