/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.CompareUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import cn.com.yusys.yusp.commons.util.collection.MapUtils;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class ArrayUtils {
    private static int INDEX_NOT_FOUND = -1;
    private static int INT_ZERO = 0;

    private ArrayUtils() {
    }

    public static <T> boolean isEmpty(T[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static <T> T[] ifEmptyGetDefault(T[] array, T[] defaultArray) {
        return ArrayUtils.isEmpty(array) ? defaultArray : array;
    }

    public static boolean isEmpty(Object array) {
        if (Objects.isNull(array)) {
            return true;
        }
        if (ArrayUtils.isArray(array)) {
            return 0 == Array.getLength(array);
        }
        throw new IllegalArgumentException("Object to provide is not a Array!");
    }

    public static boolean isEmpty(long[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static <T> boolean nonEmpty(T[] array) {
        return Objects.nonNull(array) && array.length > 0;
    }

    public static boolean nonEmpty(Object array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean nonEmpty(long[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean nonEmpty(float[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean nonEmpty(short[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean nonEmpty(int[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean nonEmpty(double[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean nonEmpty(byte[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean nonEmpty(boolean[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean nonEmpty(char[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayUtils.nonEmpty(array)) {
            return Arrays.stream(array).anyMatch(Objects::isNull);
        }
        return false;
    }

    public static <T> void requiredAnyNotNUll(T[] arr) {
        if (Objects.isNull(arr) || ArrayUtils.hasNull(arr)) {
            throw new NullPointerException();
        }
    }

    public static <T> T firstNonNull(T ... array) {
        if (ArrayUtils.nonEmpty(array)) {
            for (T arr : array) {
                if (!Objects.nonNull(arr)) continue;
                return arr;
            }
        }
        return null;
    }

    public static <T> T[] newArray(Class<?> componentType, int size) {
        return (Object[])Array.newInstance(componentType, size);
    }

    public static Object[] newArray(int size) {
        return new Object[size];
    }

    public static Class<?> getComponentType(Object array) {
        return ArrayUtils.isEmpty(array) ? null : array.getClass().getComponentType();
    }

    public static boolean isArray(Object object) {
        return !Objects.isNull(object) && object.getClass().isArray();
    }

    public static <T> T[] cast(Class<?> type, Object arrayObj) {
        if (Objects.isNull(arrayObj)) {
            throw new NullPointerException("Argument [arrayObj] is null!");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array!");
        }
        if (Objects.isNull(type)) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        T[] result = ArrayUtils.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static int length(Object array) {
        return Objects.isNull(array) ? 0 : Array.getLength(array);
    }

    public static <T> T[] append(T[] array, T ... newElements) {
        return ArrayUtils.isEmpty(array) ? newElements : ArrayUtils.insert(array, array.length, newElements);
    }

    public static <T> Object setOrAppend(Object array, T ... newElements) {
        return ArrayUtils.isEmpty(array) ? newElements : ArrayUtils.insert(array, ArrayUtils.length(array), newElements);
    }

    public static <T> T[] insert(T[] array, int index, T ... newElements) {
        return (Object[])ArrayUtils.insert(array, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ArrayUtils.isEmpty(newElements)) {
            return array;
        }
        if (ArrayUtils.isEmpty(array)) {
            return newElements;
        }
        int len = ArrayUtils.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = ArrayUtils.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static <T> T[] merge(T[] ... array) {
        T[] newArray = ArrayUtils.union(array);
        if (newArray != null) {
            Object[] objects = Stream.of(newArray).distinct().toArray();
            return ArrayUtils.cast(newArray.getClass().getComponentType(), objects);
        }
        return null;
    }

    public static <T> T[] union(T[] ... array) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (array.length == 1) {
            return array[0];
        }
        int length = ArrayUtils.parallelStream(array).filter(ArrayUtils::nonEmpty).map(arr -> ((Object[])arr).length).reduce(Integer::sum).orElse(0);
        T[] newArray = ArrayUtils.newArray(array.getClass().getComponentType().getComponentType(), length);
        int pos = 0;
        for (T[] arr2 : array) {
            if (!ArrayUtils.nonEmpty(arr2)) continue;
            System.arraycopy(arr2, 0, newArray, pos, arr2.length);
            pos += arr2.length;
        }
        return newArray;
    }

    public static <T> T copy(T src, T dest, int length) {
        if (!ArrayUtils.isArray(src) || !ArrayUtils.isArray(dest)) {
            return null;
        }
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static <T> T[] clone(T[] array) {
        return ArrayUtils.isEmpty(array) ? null : (Object[])array.clone();
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }

    public static int[] rangeIntArray(int excludedEnd) {
        return ArrayUtils.rangeIntArray(0, excludedEnd);
    }

    public static int[] rangeIntArray(int includedStart, int excludedEnd) {
        return ArrayUtils.arithmeticSequence(includedStart, excludedEnd, 1);
    }

    public static int[] arithmeticSequence(int includedStart, int excludedEnd, int dValue) {
        boolean isCanCreate;
        boolean bl = isCanCreate = includedStart > excludedEnd && dValue < 0 || excludedEnd > includedStart && dValue > 0;
        if (isCanCreate) {
            int deviation = excludedEnd - includedStart;
            int length = deviation / dValue;
            if (deviation % dValue != 0) {
                ++length;
            }
            int[] range = new int[length];
            for (int i = 0; i < length; ++i) {
                range[i] = includedStart;
                includedStart += dValue;
            }
            return range;
        }
        return new int[0];
    }

    public static byte[][] split(byte[] array, int len) {
        int x = array.length / len;
        int y = array.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(array, i * len, arr, 0, y);
            } else {
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static <T, R> R[] filterNullAndMap(T[] array, Function<? super T, ? extends R> mapper) {
        if (ArrayUtils.nonEmpty(array)) {
            List<T> list = Arrays.stream(array).filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                return null;
            }
            return list.toArray(ArrayUtils.newArray(list.get(0).getClass(), list.size()));
        }
        return null;
    }

    public static <T> T[] filter(T[] array, Predicate<? super T> predicate) {
        if (ArrayUtils.nonEmpty(array)) {
            return ArrayUtils.cast(array.getClass().getComponentType(), Arrays.stream(array).filter(predicate).toArray());
        }
        return null;
    }

    public static <T> T[] removeNull(T[] array) {
        return ArrayUtils.filter(array, Objects::nonNull);
    }

    public static <T extends CharSequence> T[] removeEmpty(T[] array) {
        return ArrayUtils.filter(array, StringUtils::nonEmpty);
    }

    public static <T extends CharSequence> T[] removeBlank(T[] array) {
        return ArrayUtils.filter(array, StringUtils::nonBlank);
    }

    public static <K, V> Map<K, V> ofHashMap(K[] keys, V[] values) {
        if (ArrayUtils.isEmpty(keys) || ArrayUtils.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = MapUtils.newHashMap(size);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <T> int indexOf(T[] array, Object object) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!Objects.equals(array[i], object)) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence cs) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!StringUtils.equalsIgnoreCase(array[i], cs)) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static <T> int lastIndexOf(T[] array, Object object) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!Objects.equals(array[i], object)) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static <T> boolean contains(T[] array, Object object) {
        return ArrayUtils.indexOf(array, object) > INDEX_NOT_FOUND;
    }

    public static <T> boolean containsAny(T[] array, T ... ts) {
        return Objects.nonNull(ts) ? ArrayUtils.parallelStream(ts).anyMatch(t -> ArrayUtils.contains(array, t)) : ArrayUtils.contains(array, null);
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence cs) {
        return ArrayUtils.indexOfIgnoreCase(array, cs) > INDEX_NOT_FOUND;
    }

    public static int indexOf(long[] array, long value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int lastIndexOf(long[] array, long value) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static boolean contains(long[] array, long value) {
        return ArrayUtils.indexOf(array, value) > INDEX_NOT_FOUND;
    }

    public static int indexOf(double[] array, double value) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int lastIndexOf(double[] array, double value) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static boolean contains(double[] array, double value) {
        return ArrayUtils.indexOf(array, value) > INDEX_NOT_FOUND;
    }

    public static int indexOf(short[] array, short value) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int lastIndexOf(short[] array, short value) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static boolean contains(short[] array, short value) {
        return ArrayUtils.indexOf(array, value) > INDEX_NOT_FOUND;
    }

    public static int indexOf(int[] array, int value) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int lastIndexOf(int[] array, int value) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static boolean contains(int[] array, int value) {
        return ArrayUtils.indexOf(array, value) > INDEX_NOT_FOUND;
    }

    public static int indexOf(float[] array, float value) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int lastIndexOf(float[] array, float value) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static boolean contains(float[] array, float value) {
        return ArrayUtils.indexOf(array, value) > INDEX_NOT_FOUND;
    }

    public static int indexOf(char[] array, char value) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int lastIndexOf(char[] array, char value) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static boolean contains(char[] array, char value) {
        return ArrayUtils.indexOf(array, value) > INDEX_NOT_FOUND;
    }

    public static int indexOf(byte[] array, byte value) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int lastIndexOf(byte[] array, byte value) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static boolean contains(byte[] array, byte value) {
        return ArrayUtils.indexOf(array, value) > INDEX_NOT_FOUND;
    }

    public static int indexOf(boolean[] array, boolean value) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static int lastIndexOf(boolean[] array, boolean value) {
        if (Objects.nonNull(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return INDEX_NOT_FOUND;
    }

    public static boolean contains(boolean[] array, boolean value) {
        return ArrayUtils.indexOf(array, value) > INDEX_NOT_FOUND;
    }

    public static Integer[] wrap(int ... ints) {
        Integer[] integers = new Integer[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            integers[i] = ints[i];
        }
        return integers;
    }

    public static int[] unwrap(Integer ... integers) {
        if (Objects.isNull(integers)) {
            return null;
        }
        return Arrays.stream(integers).mapToInt(Integer::intValue).toArray();
    }

    public static Long[] wrap(long ... longs) {
        Long[] longArray = new Long[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            longArray[i] = longs[i];
        }
        return longArray;
    }

    public static long[] unwrap(Long ... longArray) {
        if (Objects.isNull(longArray)) {
            return null;
        }
        return Arrays.stream(longArray).mapToLong(Long::longValue).toArray();
    }

    public static Short[] wrap(short ... shorts) {
        Short[] shortArray = new Short[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            shortArray[i] = shorts[i];
        }
        return shortArray;
    }

    public static short[] unwrap(Short ... shortArray) {
        if (Objects.isNull(shortArray)) {
            return null;
        }
        short[] shorts = new short[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            shorts[i] = shortArray[i];
        }
        return shorts;
    }

    public static Float[] wrap(float ... floats) {
        Float[] floatArray = new Float[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            floatArray[i] = Float.valueOf(floats[i]);
        }
        return floatArray;
    }

    public static float[] unwrap(Float ... floatArray) {
        if (Objects.isNull(floatArray)) {
            return null;
        }
        float[] floats = new float[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            floats[i] = floatArray[i].floatValue();
        }
        return floats;
    }

    public static Double[] wrap(double ... doubles) {
        Double[] doubleArray = new Double[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            doubleArray[i] = doubles[i];
        }
        return doubleArray;
    }

    public static double[] unwrap(Double ... doubleArray) {
        if (Objects.isNull(doubleArray)) {
            return null;
        }
        return Arrays.stream(doubleArray).mapToDouble(Double::doubleValue).toArray();
    }

    public static Character[] wrap(char ... chars) {
        Character[] charArray = new Character[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            charArray[i] = Character.valueOf(chars[i]);
        }
        return charArray;
    }

    public static char[] unwrap(Character ... charArray) {
        if (Objects.isNull(charArray)) {
            return null;
        }
        char[] chars = new char[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            chars[i] = charArray[i].charValue();
        }
        return chars;
    }

    public static Byte[] wrap(byte ... bytes) {
        Byte[] byteArray = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            byteArray[i] = bytes[i];
        }
        return byteArray;
    }

    public static byte[] unwrap(Byte ... byteArray) {
        if (Objects.isNull(byteArray)) {
            return null;
        }
        byte[] bytes = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            bytes[i] = byteArray[i];
        }
        return bytes;
    }

    public static Boolean[] wrap(boolean ... booleans) {
        Boolean[] booleanArray = new Boolean[booleans.length];
        for (int i = 0; i < booleans.length; ++i) {
            booleanArray[i] = booleans[i];
        }
        return booleanArray;
    }

    public static boolean[] unwrap(Boolean ... booleanArray) {
        if (Objects.isNull(booleanArray)) {
            return null;
        }
        boolean[] booleans = new boolean[booleanArray.length];
        for (int i = 0; i < booleanArray.length; ++i) {
            booleans[i] = booleanArray[i];
        }
        return booleans;
    }

    public static Object[] wrap(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        if (ArrayUtils.isArray(object)) {
            try {
                return (Object[])object;
            }
            catch (Exception e) {
                String className;
                switch (className = object.getClass().getComponentType().getName()) {
                    case "int": {
                        return ArrayUtils.wrap((int[])object);
                    }
                    case "long": {
                        return ArrayUtils.wrap((long[])object);
                    }
                    case "short": {
                        return ArrayUtils.wrap((short[])object);
                    }
                    case "float": {
                        return ArrayUtils.wrap((float[])object);
                    }
                    case "double": {
                        return ArrayUtils.wrap((double[])object);
                    }
                    case "byte": {
                        return ArrayUtils.wrap((byte[])object);
                    }
                    case "char": {
                        return ArrayUtils.wrap((char[])object);
                    }
                    case "boolean": {
                        return ArrayUtils.wrap((boolean[])object);
                    }
                }
            }
        }
        throw new IllegalArgumentException("[" + object.getClass().getName() + "] is not Array!");
    }

    public static <T> T get(Object array, int index) {
        if (Objects.isNull(array)) {
            return null;
        }
        try {
            return (T)Array.get(array, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static <T> T[] sub(T[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return ArrayUtils.newArray(array.getClass().getComponentType(), 0);
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static <T> T[] sub(T[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static int[] sub(int[] array, int start, int end) {
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return new int[0];
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static int[] sub(int[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static float[] sub(float[] array, int start, int end) {
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return new float[0];
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static float[] sub(float[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static short[] sub(short[] array, int start, int end) {
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return new short[0];
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static short[] sub(short[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static long[] sub(long[] array, int start, int end) {
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return new long[0];
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static long[] sub(long[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static double[] sub(double[] array, int start, int end) {
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return new double[0];
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static double[] sub(double[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static char[] sub(char[] array, int start, int end) {
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return new char[0];
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static char[] sub(char[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static byte[] sub(byte[] array, int start, int end) {
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return new byte[0];
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static byte[] sub(byte[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static boolean[] sub(boolean[] array, int start, int end) {
        int length = ArrayUtils.length(array);
        if (start < INT_ZERO || start > end || end > length) {
            throw new IndexOutOfBoundsException("start location and end location must usable!");
        }
        if (start == length) {
            return new boolean[0];
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static boolean[] sub(boolean[] array, int start) {
        return ArrayUtils.sub(array, start, ArrayUtils.length(array));
    }

    public static byte[] subarray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return new byte[0];
        }
        byte[] subarray = new byte[newSize];
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static String toString(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (ArrayUtils.isArray(object)) {
            try {
                return Arrays.deepToString((Object[])object);
            }
            catch (Exception e) {
                return null;
            }
        }
        return object.toString();
    }

    public static <T> String join(T[] array, CharSequence cs) {
        return ArrayUtils.join(array, cs, null, null);
    }

    public static <T> String join(T[] array, CharSequence cs, String prefix, String suffix) {
        if (Objects.isNull(array)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (T item : array) {
            ++count;
            sb.append(Objects.nonNull(prefix) ? prefix : "");
            sb.append(item);
            sb.append(Objects.nonNull(suffix) ? suffix : "");
            if (count == array.length) continue;
            sb.append(Objects.nonNull(cs) ? cs : "");
        }
        return sb.toString();
    }

    public static String join(int[] array, CharSequence cs) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (int item : array) {
            if (start) {
                start = false;
            } else {
                builder.append(Objects.nonNull(cs) ? cs : "");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String join(long[] array, CharSequence cs) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (long item : array) {
            if (start) {
                start = false;
            } else {
                builder.append(Objects.nonNull(cs) ? cs : "");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String join(short[] array, CharSequence cs) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (short item : array) {
            if (start) {
                start = false;
            } else {
                builder.append(Objects.nonNull(cs) ? cs : "");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String join(float[] array, CharSequence cs) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (float item : array) {
            if (start) {
                start = false;
            } else {
                builder.append(Objects.nonNull(cs) ? cs : "");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String join(double[] array, CharSequence cs) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (double item : array) {
            if (start) {
                start = false;
            } else {
                builder.append(Objects.nonNull(cs) ? cs : "");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String join(char[] array, CharSequence cs) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (char item : array) {
            if (start) {
                start = false;
            } else {
                builder.append(Objects.nonNull(cs) ? cs : "");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String join(byte[] array, CharSequence cs) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (byte item : array) {
            if (start) {
                start = false;
            } else {
                builder.append(Objects.nonNull(cs) ? cs : "");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String join(boolean[] array, CharSequence cs) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (boolean item : array) {
            if (start) {
                start = false;
            } else {
                builder.append(Objects.nonNull(cs) ? cs : "");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String join(Object array, CharSequence cs) {
        if (ArrayUtils.isArray(array)) {
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                String componentTypeName;
                switch (componentTypeName = componentType.getName()) {
                    case "long": {
                        return ArrayUtils.join((long[])array, cs);
                    }
                    case "int": {
                        return ArrayUtils.join((int[])array, cs);
                    }
                    case "short": {
                        return ArrayUtils.join((short[])array, cs);
                    }
                    case "char": {
                        return ArrayUtils.join((char[])array, cs);
                    }
                    case "byte": {
                        return ArrayUtils.join((byte[])array, cs);
                    }
                    case "boolean": {
                        return ArrayUtils.join((boolean[])array, cs);
                    }
                    case "float": {
                        return ArrayUtils.join((float[])array, cs);
                    }
                    case "double": {
                        return ArrayUtils.join((double[])array, cs);
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: [" + componentTypeName + "]");
            }
            return ArrayUtils.join((Object[])array, cs);
        }
        throw new IllegalArgumentException("[object] is not a Array!");
    }

    public static byte[] toArray(ByteBuffer byteBuffer) {
        if (Objects.isNull(byteBuffer)) {
            return null;
        }
        if (!byteBuffer.hasArray()) {
            int oldPosition = byteBuffer.position();
            byteBuffer.position(0);
            int size = byteBuffer.limit();
            byte[] buffers = new byte[size];
            byteBuffer.get(buffers);
            byteBuffer.position(oldPosition);
            return buffers;
        }
        return Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        return ArrayUtils.toArray(ListUtils.newArrayList(iterator), componentType);
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        return ArrayUtils.toArray(ListUtils.newArrayList(iterable), componentType);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        T[] array = ArrayUtils.newArray(componentType, collection.size());
        return collection.toArray(array);
    }

    public static <T> T[] remove(T[] array, int index) {
        return (Object[])ArrayUtils.remove(array, index);
    }

    public static int[] remove(int[] array, int index) {
        return (int[])ArrayUtils.remove((Object)array, index);
    }

    public static short[] remove(short[] array, int index) {
        return (short[])ArrayUtils.remove((Object)array, index);
    }

    public static long[] remove(long[] array, int index) {
        return (long[])ArrayUtils.remove((Object)array, index);
    }

    public static float[] remove(float[] array, int index) {
        return (float[])ArrayUtils.remove((Object)array, index);
    }

    public static double[] remove(double[] array, int index) {
        return (double[])ArrayUtils.remove((Object)array, index);
    }

    public static char[] remove(char[] array, int index) {
        return (char[])ArrayUtils.remove((Object)array, index);
    }

    public static boolean[] remove(boolean[] array, int index) {
        return (boolean[])ArrayUtils.remove((Object)array, index);
    }

    public static byte[] remove(byte[] array, int index) {
        return (byte[])ArrayUtils.remove((Object)array, index);
    }

    public static Object remove(Object array, int index) {
        if (Objects.isNull(array)) {
            return null;
        }
        int length = ArrayUtils.length(array);
        if (index < 0 || index >= length) {
            return array;
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static <T> T[] removeElement(T[] array, T element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static int[] removeElement(int[] array, int element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static short[] removeElement(short[] array, short element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static long[] removeElement(long[] array, long element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static float[] removeElement(float[] array, float element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static double[] removeElement(double[] array, double element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static char[] removeElement(char[] array, char element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static boolean[] removeElement(boolean[] array, boolean element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static byte[] removeElement(byte[] array, byte element) {
        return ArrayUtils.remove(array, ArrayUtils.indexOf(array, element));
    }

    public static <T> T[] removeAll(T[] array, T element) {
        T[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static int[] removeAll(int[] array, int element) {
        int[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static short[] removeAll(short[] array, short element) {
        short[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static long[] removeAll(long[] array, long element) {
        long[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static float[] removeAll(float[] array, float element) {
        float[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static double[] removeAll(double[] array, double element) {
        double[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static char[] removeAll(char[] array, char element) {
        char[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static byte[] removeAll(byte[] array, byte element) {
        byte[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static boolean[] removeAll(boolean[] array, boolean element) {
        boolean[] newArray = array;
        int index = ArrayUtils.indexOf(array, element);
        while (index != INDEX_NOT_FOUND) {
            newArray = ArrayUtils.remove(newArray, index);
            index = ArrayUtils.indexOf(newArray, element);
        }
        return newArray;
    }

    public static <T> T[] reverse(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <T> T[] reverse(T[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static int[] reverse(int[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static int[] reverse(int[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static short[] reverse(short[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static short[] reverse(short[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static long[] reverse(long[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static long[] reverse(long[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static float[] reverse(float[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static float[] reverse(float[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static double[] reverse(double[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static double[] reverse(double[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static char[] reverse(char[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static char[] reverse(char[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static byte[] reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static byte[] reverse(byte[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static boolean[] reverse(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static boolean[] reverse(boolean[] array) {
        return ArrayUtils.reverse(array, 0, ArrayUtils.length(array));
    }

    public static <T extends Comparable<? super T>> T min(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return (T)((Comparable)ArrayUtils.parallelStream(array).min(CompareUtils::compare).orElse(null));
    }

    public static int min(int ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).min().orElse(Integer.MIN_VALUE);
    }

    public static long min(long ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).min().orElse(Long.MIN_VALUE);
    }

    public static short min(short ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).min(Short::compare).orElse((short)Short.MIN_VALUE);
    }

    public static float min(float ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).min(Float::compare).orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
    }

    public static double min(double ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).min().orElse(Double.MIN_VALUE);
    }

    public static byte min(byte ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).min(Byte::compare).orElse((byte)-128);
    }

    public static char min(char ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).min(Character::compare).orElse(Character.valueOf('\u0000')).charValue();
    }

    public static <T extends Comparable<? super T>> T max(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return (T)((Comparable)ArrayUtils.parallelStream(array).max(CompareUtils::compare).orElse(null));
    }

    public static int max(int ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).max().orElse(Integer.MAX_VALUE);
    }

    public static long max(long ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).max().orElse(Long.MAX_VALUE);
    }

    public static short max(short ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).max(Short::compare).orElse((short)Short.MAX_VALUE);
    }

    public static float max(float ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).max(Float::compare).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
    }

    public static double max(double ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).max().orElse(Double.MAX_VALUE);
    }

    public static byte max(byte ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).max(Byte::compare).orElse((byte)127);
    }

    public static char max(char ... array) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        return ArrayUtils.parallelStream(array).max(Character::compare).orElse(Character.valueOf('\uffff')).charValue();
    }

    public static int[] swap(int[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        int tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static float[] swap(float[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        float tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static short[] swap(short[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        short tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static long[] swap(long[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        long tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static double[] swap(double[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        double tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static byte[] swap(byte[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        byte tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static char[] swap(char[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        char tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static boolean[] swap(boolean[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        boolean tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static <T> T[] swap(T[] array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        if (index1 < 0 || index1 >= array.length || index2 < 0 || index2 >= array.length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (array.length - 1));
        }
        T tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static Object swap(Object array, int index1, int index2) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int length = Array.getLength(array);
        if (index1 < 0 || index1 >= length || index2 < 0 || index2 >= length) {
            throw new IndexOutOfBoundsException("Index must between 0 to " + (length - 1));
        }
        Object tmp = ArrayUtils.get(array, index1);
        Array.set(array, index1, Array.get(array, index2));
        Array.set(array, index2, tmp);
        return array;
    }

    public static int countEmpty(Object ... objects) {
        if (ArrayUtils.nonEmpty(objects)) {
            return (int)ArrayUtils.parallelStream(objects).filter(Objects::isNull).count();
        }
        return 0;
    }

    public static boolean hasEmpty(Object ... objects) {
        if (ArrayUtils.nonEmpty(objects)) {
            return ArrayUtils.parallelStream(objects).anyMatch(Objects::isNull);
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... objects) {
        return ArrayUtils.isEmpty(objects) || ArrayUtils.countEmpty(objects) == objects.length;
    }

    public static boolean isAllNonEmpty(Object ... objects) {
        return !ArrayUtils.isAllEmpty(objects);
    }

    public static <T> T[] distinct(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        return ArrayUtils.cast(array.getClass().getComponentType(), ArrayUtils.parallelStream(array).distinct().toArray());
    }

    public static <T> Stream<T> parallelStream(T[] array, int startInclusive, int endExclusive) {
        return (Stream)Arrays.stream(array, startInclusive, endExclusive).parallel();
    }

    public static <T> Stream<T> parallelStream(T[] array) {
        return ArrayUtils.parallelStream(array, 0, ArrayUtils.length(array));
    }

    public static IntStream parallelStream(int[] array) {
        return Arrays.stream(array).parallel();
    }

    public static LongStream parallelStream(long[] array) {
        return Arrays.stream(array).parallel();
    }

    public static Stream<Short> parallelStream(short[] array) {
        return (Stream)Arrays.stream(ArrayUtils.wrap(array)).parallel();
    }

    public static Stream<Float> parallelStream(float[] array) {
        return (Stream)Arrays.stream(ArrayUtils.wrap(array)).parallel();
    }

    public static DoubleStream parallelStream(double[] array) {
        return Arrays.stream(array).parallel();
    }

    public static Stream<Byte> parallelStream(byte[] array) {
        return (Stream)Arrays.stream(ArrayUtils.wrap(array)).parallel();
    }

    public static Stream<Character> parallelStream(char[] array) {
        return (Stream)Arrays.stream(ArrayUtils.wrap(array)).parallel();
    }

    public static byte[] addAll(byte[] array1, byte ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static <T> T[] resize(T[] data, int newSize, Class<?> componentType) {
        if (newSize < 0) {
            return data;
        }
        T[] newArray = ArrayUtils.newArray(componentType, newSize);
        if (newSize > 0 && ArrayUtils.nonEmpty(data)) {
            System.arraycopy(data, 0, newArray, 0, Math.min(data.length, newSize));
        }
        return newArray;
    }

    public static Object resize(Object array, int newSize) {
        if (newSize < 0) {
            return array;
        }
        if (null == array) {
            return null;
        }
        int length = ArrayUtils.length(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (newSize > 0 && ArrayUtils.nonEmpty(array)) {
            System.arraycopy(array, 0, newArray, 0, Math.min(length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayUtils.resize(buffer, newSize, buffer.getClass().getComponentType());
    }
}

