/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.util;

import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.ExcelCsvHead;
import cn.com.yusys.yusp.commons.excelcsv.handle.HeadProperty;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CommonHeadBuilder<T> {
    private final DataHandle dataHandle;
    private final Class<T> headClass;
    private Set<String> excludeColumns = new LinkedHashSet<String>();
    private Set<String> includeColumns = new LinkedHashSet<String>();

    public CommonHeadBuilder(Class<T> headClass, DataHandle dataHandle) {
        this.headClass = headClass;
        this.dataHandle = dataHandle;
    }

    public static <H> CommonHeadBuilder<H> builder(Class<H> headClass, DataHandle dataHandle) {
        return new CommonHeadBuilder<H>(headClass, dataHandle);
    }

    public CommonHeadBuilder<T> addIncludeColumns(String ... columns) {
        this.includeColumns.addAll(Arrays.asList(columns));
        return this;
    }

    public CommonHeadBuilder<T> addExcludeColumns(String ... columns) {
        this.excludeColumns.addAll(Arrays.asList(columns));
        return this;
    }

    public HeadProperty build() {
        List<ExcelCsvHead> excelCsvHeads = this.dataHandle.analysis(this.headClass);
        HeadProperty property = new HeadProperty(this.headClass, excelCsvHeads);
        property.setExcludeColumns(this.excludeColumns);
        property.setIncludeColumns(this.includeColumns);
        property.build();
        return property;
    }
}

