/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.handle.impl.adapter;

import cn.com.yusys.yusp.commons.excelcsv.handle.impl.adapter.CacheableLookupAdapter;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisLookupAdapter
implements CacheableLookupAdapter {
    private static final String ADAPTER_DICT_VERSION1 = "V1";
    private static final String ADAPTER_DICT_VERSION2 = "V2";
    private static final String ADAPTER_DICT_VERSION3 = "V3";
    private final RedisLookupCodeService redisLookupCodeService;

    public RedisLookupAdapter(RedisLookupCodeService redisLookupCodeService) {
        this.redisLookupCodeService = redisLookupCodeService;
    }

    @Override
    public Map<String, String> getLookup(String dictCode, String version) {
        if (ADAPTER_DICT_VERSION1.equals(version)) {
            return this.getAdapterDictVersion1(dictCode);
        }
        if (ADAPTER_DICT_VERSION2.equals(version)) {
            return this.getAdapterNewDictVersion(dictCode, this.redisLookupCodeService::version2);
        }
        if (ADAPTER_DICT_VERSION3.equals(version)) {
            return this.getAdapterNewDictVersion(dictCode, this.redisLookupCodeService::version3);
        }
        return null;
    }

    private Map<String, String> getAdapterDictVersion1(String lookupCode) {
        List<Map<String, String>> itemMapList;
        HashMap<String, String> itemMap = null;
        Map<String, List<Map<String, String>>> resultMap = this.redisLookupCodeService.version1(lookupCode);
        if (null != resultMap && CollectionUtils.nonEmpty(itemMapList = resultMap.get(lookupCode))) {
            itemMap = new HashMap<String, String>(itemMapList.size());
            for (Map<String, String> map : itemMapList) {
                itemMap.put(map.get("key"), map.get("value"));
            }
        }
        return itemMap;
    }

    private Map<String, String> getAdapterNewDictVersion(String lookupCode, Function<String, List<Object>> function) {
        List<Object> resultList = function.apply(lookupCode);
        if (CollectionUtils.nonEmpty(resultList)) {
            HashMap<String, String> itemMap = new HashMap<String, String>(resultList.size());
            resultList.stream().filter(obj -> Map.class.isAssignableFrom(obj.getClass())).map(obj -> (Map)obj).forEach(map -> itemMap.put(StringUtils.replaceObjNull(map.get("key")), StringUtils.replaceObjNull(map.get("value"))));
            return itemMap;
        }
        return Collections.emptyMap();
    }

    public static class RedisLookupCodeService {
        private static final String REDIS_HASH_DICT_KEY_PREFIX = "datadict";
        private final StringRedisTemplate stringRedisTemplate;

        public RedisLookupCodeService(StringRedisTemplate stringRedisTemplate) {
            this.stringRedisTemplate = stringRedisTemplate;
        }

        @Cacheable(value={"AdminSmLookupItem"}, key="#lookupCode")
        public Map<String, List<Map<String, String>>> version1(String lookupCode) {
            return null;
        }

        public List<Object> version2(String lookupCode) {
            BoundHashOperations dataDict = this.stringRedisTemplate.opsForHash().getOperations().boundHashOps((Object)REDIS_HASH_DICT_KEY_PREFIX);
            Object object = dataDict.get((Object)lookupCode);
            return (List)ObjectMapperUtils.toObject((String)StringUtils.replaceObjNull((Object)object), List.class);
        }

        public List<Object> version3(String lookupCode) {
            String key = StringUtils.builder0((Object[])new Object[]{REDIS_HASH_DICT_KEY_PREFIX, "_", LocaleContextHolder.getLocale().toString()});
            BoundHashOperations dataDict = this.stringRedisTemplate.opsForHash().getOperations().boundHashOps((Object)key);
            Object object = dataDict.get((Object)lookupCode);
            return (List)ObjectMapperUtils.toObject((String)StringUtils.replaceObjNull((Object)object), List.class);
        }
    }
}

