/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.easyexcel;

import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalDateConverter;
import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalDateTimeConverter;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.HeadProperty;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.enums.WriteTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.NumberFormatProperty;
import com.alibaba.excel.util.ClassUtils;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.util.WriteHandlerUtils;
import com.alibaba.excel.write.executor.AbstractExcelWriteExecutor;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.alibaba.excel.write.property.ExcelWriteHeadProperty;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuExcelWriteAddExecutor
extends AbstractExcelWriteExecutor {
    private static final Logger log = LoggerFactory.getLogger(YuExcelWriteAddExecutor.class);
    private final int sheetMaxRow;
    private final DataHandle dataHandle;
    private int sheetNo = 0;
    private int newRowIndex;
    private int relativeRowIndex = 0;
    private final HeadProperty headProperty;
    private final Map<Field, CellStyle> cellStyleCache = new ConcurrentHashMap<Field, CellStyle>(8);

    public YuExcelWriteAddExecutor(WriteContext writeContext, HeadProperty headProperty, int sheetMaxRow, DataHandle dataHandle) {
        super(writeContext);
        if (headProperty == null || headProperty.getNotIgnoreHeadInfos() == null || headProperty.getNotIgnoreHeadInfos().isEmpty() || headProperty.getExcelCsvHeads() == null || headProperty.getExcelCsvHeads().isEmpty()) {
            throw new IllegalStateException("excel heads can not be null or empty");
        }
        this.headProperty = headProperty;
        this.sheetMaxRow = sheetMaxRow;
        this.dataHandle = dataHandle;
    }

    public void add(Object data) {
        if (data == null) {
            throw new NullPointerException("The data can not be null.");
        }
        TreeMap<Integer, Field> sortedAllFiledMap = new TreeMap<Integer, Field>();
        this.analysisHead();
        this.createNewSheet();
        if (data instanceof Iterable) {
            Iterable objects = (Iterable)data;
            for (Object rowData : objects) {
                if (this.relativeRowIndex == this.sheetMaxRow) {
                    this.analysisHead();
                    this.createNewSheet();
                }
                this.doDataWrite(sortedAllFiledMap, rowData);
            }
        } else {
            this.doDataWrite(sortedAllFiledMap, data);
        }
    }

    private void doDataWrite(Map<Integer, Field> sortedAllFiledMap, Object oneRowData) {
        if ((oneRowData = this.dataHandle.handle(oneRowData, DataHandle.OperationType.EXPORT)) == null) {
            log.warn("return null value after custom handle while export excel file, skip.");
            return;
        }
        int n = this.relativeRowIndex + this.newRowIndex;
        this.addOneRowOfDataToExcel(oneRowData, n, this.relativeRowIndex, sortedAllFiledMap);
        ++this.relativeRowIndex;
    }

    private void analysisHead() {
        if (this.headProperty == null || this.headProperty.getExcelCsvHeads() == null || this.headProperty.getExcelCsvHeads().isEmpty()) {
            return;
        }
        ExcelWriteHeadProperty writeHeadProperty = this.writeContext.currentWriteHolder().excelWriteHeadProperty();
        writeHeadProperty.setContentPropertyMap(this.headProperty.getContentPropertyMap());
        writeHeadProperty.setFieldNameContentPropertyMap(this.headProperty.getFieldNameContentPropertyMap());
        writeHeadProperty.setHeadClazz(this.headProperty.getHeadClazz());
        writeHeadProperty.setHeadKind(HeadKindEnum.CLASS);
        writeHeadProperty.setHeadMap(this.headProperty.getHeadMap());
        writeHeadProperty.setIgnoreMap(this.headProperty.getIgnoreMap());
        writeHeadProperty.setHeadRowNumber(1);
    }

    private void createNewSheet() {
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)this.sheetNo, (String)("Sheet" + (this.sheetNo + 1))).build();
        writeSheet.setCustomConverterList(Arrays.asList(new LocalDateConverter(), new LocalDateTimeConverter()));
        if (this.headProperty != null && !this.headProperty.getHeadNames().isEmpty()) {
            this.writeContext.writeWorkbookHolder().setHead(this.headProperty.getHeadNames());
        }
        this.writeContext.currentSheet(writeSheet, WriteTypeEnum.ADD);
        this.newRowIndex = this.getNewRowIndex();
        this.relativeRowIndex = 0;
        ++this.sheetNo;
    }

    private int getNewRowIndex() {
        WriteSheetHolder writeSheetHolder = this.writeContext.writeSheetHolder();
        int newRowIndex = writeSheetHolder.getNewRowIndexAndStartDoWrite();
        if (writeSheetHolder.isNew() && !writeSheetHolder.getExcelWriteHeadProperty().hasHead()) {
            newRowIndex += this.writeContext.currentWriteHolder().relativeHeadRowIndex();
        }
        return newRowIndex;
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n, int relativeRowIndex, Map<Integer, Field> sortedAllFiledMap) {
        if (oneRowData == null) {
            return;
        }
        WriteHandlerUtils.beforeRowCreate((WriteContext)this.writeContext, (Integer)n, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        Row row = WorkBookUtil.createRow((Sheet)this.writeContext.writeSheetHolder().getSheet(), (int)n);
        WriteHandlerUtils.afterRowCreate((WriteContext)this.writeContext, (Row)row, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        if (oneRowData instanceof List) {
            this.addBasicTypeToExcel((List)oneRowData, row, relativeRowIndex);
        } else {
            this.addJavaObjectToExcel(oneRowData, row, relativeRowIndex, sortedAllFiledMap);
        }
        WriteHandlerUtils.afterRowDispose((WriteContext)this.writeContext, (Row)row, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
    }

    private void addBasicTypeToExcel(List<Object> oneRowData, Row row, int relativeRowIndex) {
        if (CollectionUtils.isEmpty(oneRowData)) {
            return;
        }
        Map headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
        int dataIndex = 0;
        int cellIndex = 0;
        for (Map.Entry entry : headMap.entrySet()) {
            if (dataIndex >= oneRowData.size()) {
                return;
            }
            cellIndex = (Integer)entry.getKey();
            Head head = (Head)entry.getValue();
            this.doAddBasicTypeToExcel(oneRowData, head, row, relativeRowIndex, dataIndex++, cellIndex);
        }
        if (dataIndex >= oneRowData.size()) {
            return;
        }
        if (cellIndex != 0) {
            ++cellIndex;
        }
        int size = oneRowData.size() - dataIndex;
        for (int i = 0; i < size; ++i) {
            this.doAddBasicTypeToExcel(oneRowData, null, row, relativeRowIndex, dataIndex++, cellIndex++);
        }
    }

    private void doAddBasicTypeToExcel(List<Object> oneRowData, Head head, Row row, int relativeRowIndex, int dataIndex, int cellIndex) {
        if (this.writeContext.currentWriteHolder().ignore(null, Integer.valueOf(cellIndex))) {
            return;
        }
        WriteHandlerUtils.beforeCellCreate((WriteContext)this.writeContext, (Row)row, (Head)head, (Integer)cellIndex, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        Cell cell = WorkBookUtil.createCell((Row)row, (int)cellIndex);
        WriteHandlerUtils.afterCellCreate((WriteContext)this.writeContext, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        Object value = oneRowData.get(dataIndex);
        CellData cellData = this.converterAndSet(this.writeContext.currentWriteHolder(), value == null ? null : value.getClass(), cell, value, null, head, relativeRowIndex);
        WriteHandlerUtils.afterCellDispose((WriteContext)this.writeContext, (CellData)cellData, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
    }

    private void addJavaObjectToExcel(Object oneRowData, Row row, int relativeRowIndex, Map<Integer, Field> sortedAllFiledMap) {
        WriteHolder currentWriteHolder = this.writeContext.currentWriteHolder();
        BeanMap beanMap = BeanMap.create((Object)oneRowData);
        int cellIndex = 0;
        if (HeadKindEnum.CLASS.equals((Object)this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadKind())) {
            Map headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
            Map contentPropertyMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getContentPropertyMap();
            for (Map.Entry entry : contentPropertyMap.entrySet()) {
                NumberFormatProperty numberFormatProperty;
                cellIndex = (Integer)entry.getKey();
                ExcelContentProperty excelContentProperty = (ExcelContentProperty)entry.getValue();
                String name = excelContentProperty.getField().getName();
                if (this.writeContext.currentWriteHolder().ignore(name, Integer.valueOf(cellIndex)) || !beanMap.containsKey((Object)name)) continue;
                Head head = (Head)headMap.get(cellIndex);
                WriteHandlerUtils.beforeCellCreate((WriteContext)this.writeContext, (Row)row, (Head)head, (Integer)cellIndex, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
                Cell cell = WorkBookUtil.createCell((Row)row, (int)cellIndex);
                if (excelContentProperty.getNumberFormatProperty() != null && (numberFormatProperty = excelContentProperty.getNumberFormatProperty()).getFormat().replaceAll("[#,.0]", "").isEmpty()) {
                    DataFormat dataFormat = this.writeContext.writeWorkbookHolder().getWorkbook().createDataFormat();
                    CellStyle style = this.cellStyleCache.computeIfAbsent(excelContentProperty.getField(), field -> this.writeContext.writeWorkbookHolder().getWorkbook().createCellStyle());
                    style.setDataFormat(dataFormat.getFormat(excelContentProperty.getNumberFormatProperty().getFormat()));
                    cell.setCellStyle(style);
                }
                WriteHandlerUtils.afterCellCreate((WriteContext)this.writeContext, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
                Object value = beanMap.get((Object)name);
                CellData cellData = this.converterAndSet(currentWriteHolder, excelContentProperty.getField().getType(), cell, value, excelContentProperty, head, relativeRowIndex);
                WriteHandlerUtils.afterCellDispose((WriteContext)this.writeContext, (CellData)cellData, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
            }
        }
    }

    private void initSortedAllFiledMapFieldList(Class clazz, Map<Integer, Field> sortedAllFiledMap) {
        if (sortedAllFiledMap.isEmpty()) {
            WriteWorkbookHolder writeWorkbookHolder = this.writeContext.writeWorkbookHolder();
            boolean needIgnore = !CollectionUtils.isEmpty((Collection)writeWorkbookHolder.getExcludeColumnFiledNames()) || !CollectionUtils.isEmpty((Collection)writeWorkbookHolder.getExcludeColumnIndexes()) || !CollectionUtils.isEmpty((Collection)writeWorkbookHolder.getIncludeColumnFiledNames()) || !CollectionUtils.isEmpty((Collection)writeWorkbookHolder.getIncludeColumnIndexes());
            ClassUtils.declaredFields((Class)clazz, sortedAllFiledMap, (Boolean)writeWorkbookHolder.getWriteWorkbook().getConvertAllFiled(), (Boolean)needIgnore, (WriteHolder)writeWorkbookHolder);
        }
    }
}

