/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.easyexcel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeConverter
implements Converter<LocalTime> {
    private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    private DateTimeFormatter formatter;

    public LocalTimeConverter() {
        this.formatter = DateTimeFormatter.ofPattern(DEFAULT_TIME_FORMAT);
    }

    public LocalTimeConverter(String format) {
        this.formatter = format != null && !format.isEmpty() ? DateTimeFormatter.ofPattern(format) : DateTimeFormatter.ofPattern(DEFAULT_TIME_FORMAT);
    }

    public Class<LocalTime> supportJavaTypeKey() {
        return LocalTime.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public LocalTime convertToJavaData(CellData cellData, ExcelContentProperty property, GlobalConfiguration globalConfiguration) throws Exception {
        if (cellData.getStringValue() == null || cellData.getStringValue().isEmpty()) {
            return null;
        }
        return LocalTime.parse(cellData.getStringValue(), this.formatter);
    }

    public CellData<?> convertToExcelData(LocalTime localTime, ExcelContentProperty property, GlobalConfiguration globalConfiguration) throws Exception {
        if (localTime == null) {
            return new CellData("");
        }
        return new CellData(this.formatter.format(localTime));
    }
}

