/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.bill;

import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.jxls.area.CommandData;
import org.jxls.area.XlsArea;
import org.jxls.common.AreaRef;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsAreaExt
extends XlsArea {
    private static final Logger log = LoggerFactory.getLogger(XlsAreaExt.class);

    public XlsAreaExt(AreaRef areaRef, Transformer transformer) {
        super(areaRef, transformer);
    }

    public XlsAreaExt(String areaRef, Transformer transformer) {
        super(areaRef, transformer);
    }

    public XlsAreaExt(CellRef startCell, CellRef endCell, Transformer transformer) {
        super(startCell, endCell, transformer);
    }

    public XlsAreaExt(CellRef startCellRef, Size size, List<CommandData> commandDataList, Transformer transformer) {
        super(startCellRef, size, commandDataList, transformer);
    }

    public XlsAreaExt(CellRef startCellRef, Size size) {
        super(startCellRef, size);
    }

    public XlsAreaExt(CellRef startCellRef, Size size, Transformer transformer) {
        super(startCellRef, size, transformer);
    }

    public Size applyAt(CellRef cellRef, Context context) {
        int templateHeight;
        Size newSize = super.applyAt(cellRef, context);
        int areaNewHeight = newSize.getHeight();
        if (areaNewHeight < (templateHeight = this.getSize().getHeight())) {
            log.debug("area actual height:{} less than template height:{},try remove cells data.", (Object)areaNewHeight, (Object)templateHeight);
            Transformer transformer = this.getTransformer();
            if (transformer instanceof PoiTransformer) {
                String sheetName = this.getAreaRef().getSheetName();
                PoiTransformer poiTransformer = (PoiTransformer)transformer;
                Sheet sheet = poiTransformer.getWorkbook().getSheet(sheetName);
                for (int i = areaNewHeight; i < templateHeight; ++i) {
                    log.debug("remove sheet:{},row:{}", (Object)sheetName, (Object)i);
                    sheet.removeRow(sheet.getRow(i));
                }
            }
        }
        return newSize;
    }
}

