/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.bill;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.Command;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.transform.poi.PoiTransformer;

public class Merge2Command
extends AbstractCommand {
    public static final String COMMAND_NAME = "merge2";
    public static final String EXCLAMATION_MARK = "!";
    private String cellPos = null;
    private String cols;
    private String rows;
    private String minCols;
    private String minRows;
    private Area area;

    public String getName() {
        return COMMAND_NAME;
    }

    public String getCols() {
        return this.cols;
    }

    public void setCols(String cols) {
        this.cols = cols;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public String getMinCols() {
        return this.minCols;
    }

    public void setMinCols(String minCols) {
        this.minCols = minCols;
    }

    public String getMinRows() {
        return this.minRows;
    }

    public void setMinRows(String minRows) {
        this.minRows = minRows;
    }

    public String getCellPos() {
        return this.cellPos;
    }

    public void setCellPos(String cellPos) {
        this.cellPos = cellPos;
    }

    public Command addArea(Area area) {
        if (!super.getAreaList().isEmpty()) {
            throw new IllegalArgumentException("You can only add 1 area to 'merge2' command!");
        }
        this.area = area;
        return super.addArea(area);
    }

    public Size applyAt(CellRef cellRef, Context context) {
        int rowsT = this.getVal(this.rows, context);
        int colsT = this.getVal(this.cols, context);
        rowsT = Math.max(this.getVal(this.minRows, context), rowsT);
        colsT = Math.max(this.getVal(this.minCols, context), colsT);
        rowsT = rowsT > 0 ? rowsT : this.area.getSize().getHeight();
        int n = colsT = colsT > 0 ? colsT : this.area.getSize().getWidth();
        if (rowsT > 1 || colsT > 1) {
            this.getTransformer().mergeCells(cellRef, rowsT, colsT);
            CellStyle originCellStyle = this.getCellStyle(cellRef.getSheetName());
            if (originCellStyle != null) {
                for (int rowIdx = cellRef.getRow() + 1; rowIdx < cellRef.getRow() + rowsT; ++rowIdx) {
                    Cell cell2 = ((PoiTransformer)this.getTransformer()).getWorkbook().getSheet(cellRef.getSheetName()).getRow(rowIdx).getCell(cellRef.getCol());
                    if (cell2 == null) continue;
                    cell2.setCellStyle(originCellStyle);
                }
            }
        }
        this.area.applyAt(cellRef, context);
        return new Size(colsT, rowsT);
    }

    private CellStyle getCellStyle(String cellRefSheetName) {
        CellStyle cellStyle = null;
        if (this.cellPos != null) {
            CellRef cellRefOrigin = new CellRef(cellRefSheetName + EXCLAMATION_MARK + this.cellPos);
            PoiTransformer poiTransformer = (PoiTransformer)this.getTransformer();
            cellStyle = poiTransformer.getCellStyle(cellRefOrigin);
        }
        return cellStyle;
    }

    private int getVal(String expression, Context context) {
        if (expression != null && expression.trim().length() > 0) {
            Object obj = this.getTransformationConfig().getExpressionEvaluator().evaluate(expression, context.toMap());
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException var5) {
                throw new IllegalArgumentException("Expression: " + expression + " failed to resolve");
            }
        }
        return 0;
    }
}

