/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.ITemplate;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTemplate
implements ITemplate {
    private static final Logger logger = LoggerFactory.getLogger(XmlTemplate.class);
    private final String templateName;
    private final byte[] templateBytes;
    private final DataHandle dataHandle;

    public XmlTemplate(String templateName, byte[] templateBytes, DataHandle dataHandle) {
        this.templateName = templateName;
        this.templateBytes = templateBytes;
        this.dataHandle = dataHandle;
        this.initTemplate();
    }

    public XmlTemplate(File templateFile, DataHandle dataHandle) {
        this.templateName = templateFile.getName();
        try (FileInputStream is = new FileInputStream(templateFile);){
            this.templateBytes = IOUtils.readBytes((InputStream)is, (boolean)false);
        }
        catch (IOException e) {
            throw new IllegalStateException("read template file failed.", e);
        }
        this.dataHandle = dataHandle;
        this.initTemplate();
    }

    private void initTemplate() {
        throw new UnsupportedOperationException("Current operation unsupported!");
    }

    @Override
    public void export(Object model, File outFile) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(outFile));
            Throwable throwable = null;
            if (writer != null) {
                if (throwable != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ((Writer)writer).close();
                }
            }
        }
        catch (IOException e) {
            if (outFile.exists() && !outFile.delete()) {
                logger.warn("Delete temp file failed. Please delete manually.");
            }
            throw new IllegalStateException(e);
        }
    }
}

