/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.ITemplate;
import cn.com.yusys.yusp.commons.excelcsv.async.Visitor;
import cn.com.yusys.yusp.commons.excelcsv.easyexcel.HeadColumnWidthStrategy;
import cn.com.yusys.yusp.commons.excelcsv.easyexcel.YuExcelBuilderImpl;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.HeadProperty;
import cn.com.yusys.yusp.commons.excelcsv.util.RecordInfo;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.excel.util.NumberDataFormatterUtils;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelTemplate
implements ITemplate {
    private static final Logger logger = LoggerFactory.getLogger(ExcelTemplate.class);
    private Class<?> headClass;
    private int sheetMaxRow;
    private final DataHandle dataHandle;
    private HeadProperty headProperty;

    public ExcelTemplate(Class<?> headClass, DataHandle dataHandle) {
        this(headClass, -1, dataHandle);
    }

    public ExcelTemplate(Class<?> headClass, int sheetMaxRow, DataHandle dataHandle) {
        Objects.requireNonNull(headClass, "head class can not be null.");
        Objects.requireNonNull(dataHandle, "datahandle can not be null.");
        this.headClass = headClass;
        this.sheetMaxRow = sheetMaxRow;
        this.dataHandle = dataHandle;
        this.headProperty = this.dataHandle.analysisHead(headClass);
    }

    public ExcelTemplate(HeadProperty headProperty, int sheetMaxRow, DataHandle dataHandle) {
        Objects.requireNonNull(dataHandle, "datahandle can not be null.");
        this.sheetMaxRow = sheetMaxRow;
        this.dataHandle = dataHandle;
        this.headProperty = headProperty;
    }

    @Override
    public void export(Object model, File outFile) {
        try {
            this.checkSheetMaxRow(outFile);
            WriteWorkbook writeWorkbook = new WriteWorkbook();
            writeWorkbook.setFile(outFile);
            writeWorkbook.setAutoTrim(Boolean.valueOf(false));
            writeWorkbook.setCustomWriteHandlerList(Collections.singletonList(new HeadColumnWidthStrategy()));
            YuExcelBuilderImpl myExcelBuilder = new YuExcelBuilderImpl(writeWorkbook);
            myExcelBuilder.addContent(model, this.sheetMaxRow, this.headProperty, this.dataHandle);
            myExcelBuilder.finish(false);
        }
        catch (Exception e) {
            if (outFile.exists()) {
                try {
                    FileUtils.forceDelete((File)outFile);
                }
                catch (IOException ex) {
                    logger.error("Delete temp file failed. Please delete manually. IOException messgage:{}", (Object)ex.getMessage());
                }
            }
            throw new IllegalStateException("export excel error.", e);
        }
    }

    private void checkSheetMaxRow(File outFile) {
        if (this.sheetMaxRow <= 0) {
            this.sheetMaxRow = outFile.getName().endsWith(".xls") ? 65535 : 1048575;
            return;
        }
        if (outFile.getName().endsWith(".xls") && this.sheetMaxRow > 65535) {
            logger.warn("the sheet max row in xls file is 65535");
            this.sheetMaxRow = 65535;
            return;
        }
        if (outFile.getName().endsWith(".xlsx") && this.sheetMaxRow > 0x100000) {
            logger.warn("the sheet max row in xlsx file is 1024 * 1024");
            this.sheetMaxRow = 1048575;
        }
    }

    public void importData(File file, Consumer<Object> consumer, Visitor<Object> visitor) {
        try {
            this.headProperty = this.dataHandle.analysisHead(this.headClass);
            ExcelReader excelReader = ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((File)file, new AnalysisListener(consumer, visitor)).useDefaultListener(Boolean.valueOf(false)).autoTrim(Boolean.valueOf(false))).headRowNumber(Integer.valueOf(1))).build();
            List sheetList = excelReader.excelExecutor().sheetList();
            excelReader.read(sheetList);
            excelReader.finish();
        }
        catch (Exception e) {
            throw new IllegalStateException("import excel error.", e);
        }
    }

    private class AnalysisListener<T>
    extends AnalysisEventListener<T> {
        private final Consumer<Object> consumer;
        private final Visitor<Object> visitor;

        public AnalysisListener(Consumer<Object> consumer, Visitor<Object> visitor) {
            this.consumer = consumer;
            this.visitor = Optional.ofNullable(visitor).orElse(Visitor.NULL_VISITOR);
        }

        public void invokeHead(Map<Integer, CellData> headMap, AnalysisContext context) {
            super.invokeHead(headMap, context);
        }

        public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
            HashMap<String, Integer> titleMap = new HashMap<String, Integer>(headMap.size());
            for (Map.Entry<Integer, String> e : headMap.entrySet()) {
                if (titleMap.containsKey(e.getValue())) {
                    throw new IllegalStateException("there are some columns with same title in execl file.");
                }
                titleMap.put(e.getValue(), e.getKey());
            }
            ExcelTemplate.this.headProperty.getExcelCsvHeads().forEach(excelCsvHead -> excelCsvHead.setColumnIndex(titleMap.getOrDefault(excelCsvHead.getTitle(), -1)));
        }

        public void invoke(T rowData, AnalysisContext analysisContext) {
            if (analysisContext.readRowHolder().getCellMap().isEmpty()) {
                return;
            }
            RecordInfo recordInfo = RecordInfo.of(ExcelTemplate.this.headClass, ExcelTemplate.this.headProperty.getNotIgnoreHeadInfos());
            Object value = recordInfo.writeValues(ExcelTemplate.this.headClass, this.getValuesMap(rowData, analysisContext.readRowHolder().getGlobalConfiguration()));
            this.visitor.visit(value);
            value = ExcelTemplate.this.dataHandle.handle(value, DataHandle.OperationType.IMPORT);
            if (value == null) {
                logger.warn("return null value after custom handle while import excel file, skip.");
                return;
            }
            this.consumer.accept(value);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        private Map<String, Object> getValuesMap(T rowData, GlobalConfiguration globalConfiguration) {
            Map data = (Map)rowData;
            HashMap<String, Object> valuesMap = new HashMap<String, Object>(8);
            ExcelTemplate.this.headProperty.getExcelCsvHeads().forEach(excelCsvHead -> {
                if (excelCsvHead.getColumnIndex() >= 0) {
                    CellData cellData = (CellData)data.get(excelCsvHead.getColumnIndex());
                    valuesMap.put(excelCsvHead.getTitle(), cellData == null ? null : this.getCellData(cellData, globalConfiguration));
                }
            });
            return valuesMap;
        }

        private Object getCellData(CellData<?> cellData, GlobalConfiguration globalConfiguration) {
            if (cellData == null) {
                return null;
            }
            switch (cellData.getType()) {
                case EMPTY: {
                    return "";
                }
                case BOOLEAN: {
                    return cellData.getBooleanValue() == null ? null : String.valueOf(cellData.getBooleanValue());
                }
                case NUMBER: {
                    String formatString;
                    if (Objects.isNull(cellData.getNumberValue())) {
                        return null;
                    }
                    Integer dataFormat = cellData.getDataFormat();
                    if (!DateUtils.isADateFormat((Integer)dataFormat, (String)(formatString = cellData.getDataFormatString()))) {
                        return NumberDataFormatterUtils.format((Double)cellData.getNumberValue().doubleValue(), (Integer)dataFormat, (String)formatString, (GlobalConfiguration)globalConfiguration);
                    }
                    return String.valueOf(cellData.getNumberValue().doubleValue());
                }
            }
            return cellData.getStringValue();
        }
    }
}

