/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.in.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.toolkit.common.SocketTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.in.AbstractCommIn;
import java.io.Serializable;
import java.util.Map;

public class UnFixCommIn
extends AbstractCommIn
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String unitName = "Variable length communication access";
    protected String endMark;
    protected String filterMark = "false";
    protected String closeSndChannel = "false";

    @Override
    public void processSend(Map<String, Object> context, byte[] bsend, AbstractRequest request) throws Exception {
        if (bsend == null) {
            throw new ComponentException("Sending content cannot be empty");
        }
        if (request.getRequestType() == 1) {
            StreamRequest req = (StreamRequest)request;
            req.getSocketWrapper().getBos().write(bsend);
            this.printSendData(bsend);
            req.getSocketWrapper().getBos().flush();
            boolean closeSndChannel = false;
            if ("true".equals(this.closeSndChannel)) {
                closeSndChannel = true;
            }
            if (closeSndChannel) {
                req.getSocketWrapper().getSocket().shutdownOutput();
            }
        } else {
            throw new ComponentException("unknow request type:" + request.getRequestType());
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        if (request.getRequestType() == 1) {
            byte[] recv;
            StreamRequest req = (StreamRequest)request;
            byte[] endMarkBt = null;
            String endMark = UnFixCommIn.getInExpressStringValue(this.endMark, context);
            if (endMark != null) {
                if (endMark.startsWith("0x") || endMark.startsWith("0X")) {
                    String inputEndMark = endMark.substring(2);
                    endMarkBt = StringTools.string2Byte(inputEndMark);
                } else {
                    endMarkBt = endMark.getBytes();
                }
            }
            if (endMarkBt == null || endMarkBt.length == 0) {
                recv = SocketTools.readInputStreamInBuffer(req.getSocketWrapper().getBis());
            } else {
                boolean filterMark = false;
                if ("true".equals(this.filterMark)) {
                    filterMark = true;
                }
                recv = SocketTools.readInputStream(req.getSocketWrapper().getBis(), endMarkBt, !filterMark);
            }
            this.printRecvData(recv);
            return recv;
        }
        throw new ComponentException("unknow request type:" + request.getRequestType());
    }

    @Override
    public byte[] processExch(Map<String, Object> context, byte[] sendData, AbstractRequest request) throws Exception {
        this.processSend(context, sendData, request);
        return this.processRecv(context, request);
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getEndMark() {
        return this.endMark;
    }

    public void setEndMark(String endMark) {
        this.endMark = endMark;
    }

    public String getFilterMark() {
        return this.filterMark;
    }

    public void setFilterMark(String filterMark) {
        this.filterMark = filterMark;
    }

    public String getCloseSndChannel() {
        return this.closeSndChannel;
    }

    public void setCloseSndChannel(String closeSndChannel) {
        this.closeSndChannel = closeSndChannel;
    }

    public static long getSerialversionuid() {
        return 1L;
    }
}

