/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class CastorTools {
    public static final String ENCODING_UTF8 = "utf-8";

    public static Object unmarshaller(String filename, Class<?> clazzObject, ClassLoader classLoader) throws Exception {
        return CastorTools.unmarshaller(new File(filename), clazzObject, classLoader);
    }

    public static Object unmarshaller(File file, Class<?> clazzObject, ClassLoader classLoader) throws Exception {
        Reader r = null;
        Object object = null;
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(file), ENCODING_UTF8);
            Unmarshaller unmarshaller = new Unmarshaller(clazzObject);
            if (classLoader != null) {
                unmarshaller.getInternalContext().setClassLoader(classLoader);
            }
            object = unmarshaller.unmarshal(r);
        }
        catch (Exception e) {
            throw new Exception("unmarshaller file exception: " + file.getAbsolutePath(), e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshaller(InputStream inputStream, Class<?> clazzObject) throws Exception {
        InputStreamReader r = null;
        Object object = null;
        try {
            r = new InputStreamReader(inputStream, ENCODING_UTF8);
            Unmarshaller unmarshaller = new Unmarshaller(clazzObject);
            object = unmarshaller.unmarshal((Reader)r);
        }
        finally {
            if (r != null) {
                try {
                    ((Reader)r).close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshaller(Object topObject, ClassLoader classLoader) throws Exception {
        String xmlConent = null;
        StringWriter w = new StringWriter();
        try {
            Marshaller marshaller = new Marshaller((Writer)w);
            if (classLoader == null) {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(Thread.currentThread().getContextClassLoader());
            } else {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(classLoader);
            }
            marshaller.setEncoding(ENCODING_UTF8);
            marshaller.marshal(topObject);
            xmlConent = w.toString();
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException iOException) {}
        }
        return xmlConent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] marshaller2Byte(Object topObject, ClassLoader classLoader) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, ENCODING_UTF8);
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            if (classLoader == null) {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(Thread.currentThread().getContextClassLoader());
            } else {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(classLoader);
            }
            marshaller.marshal(topObject);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                    outputStream = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void genSourceCode(String dir, String schemaFile, String packageName) throws IOException {
        SourceGenerator generator = new SourceGenerator();
        generator.setDestDir(dir);
        generator.setDescriptorCreation(true);
        generator.setCreateMarshalMethods(false);
        generator.generateSource(schemaFile, packageName);
    }
}

