/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.core;

import cn.com.yusys.yusp.bsp.resources.core.BeanLifeCycle;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.lang.NonNull;

public abstract class AbstractBean
implements BeanLifeCycle,
BeanNameAware {
    protected boolean alive;
    protected String bundlerId;
    protected String moduleId;
    protected String beanName;
    transient String sid;

    @Override
    public void start() throws Exception {
        int index;
        this.setAlive(true);
        this.sid = Thread.currentThread().getName();
        int li = this.sid.lastIndexOf("-");
        if (li > 0) {
            this.sid = this.sid.substring(0, li);
        }
        if ((index = this.sid.indexOf("/")) > 0) {
            this.setBundlerId(this.sid.substring(0, index));
            this.setModuleId(this.sid.substring(index + 1));
        } else {
            this.setBundlerId(this.sid);
        }
        try {
            this.doStart();
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public abstract void doStart() throws Exception;

    @Override
    public void stop() throws Exception {
        this.setAlive(false);
        this.doStop();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(@NonNull String beanName) {
        this.beanName = beanName;
    }

    public abstract void doStop() throws Exception;

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public String getBundlerId() {
        return this.bundlerId;
    }

    public void setBundlerId(String bundlerId) {
        this.bundlerId = bundlerId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getSid() {
        if (this.sid == null) {
            this.sid = this.moduleId == null ? this.bundlerId : this.bundlerId + "/" + this.moduleId;
        }
        return this.sid;
    }
}

